// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The response body to use in a custom response to a web request. This is referenced by key from CustomResponse`CustomResponseBodyKey`.
 */
class CustomResponseBody private constructor(builder: Builder) {
    /**
     * The payload of the custom response.
     *
     * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    val content: kotlin.String? = builder.content
    /**
     * The type of content in the payload that you are defining in the `Content` string.
     */
    val contentType: aws.sdk.kotlin.services.wafv2.model.ResponseContentType? = builder.contentType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CustomResponseBody = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomResponseBody(")
        append("content=$content,")
        append("contentType=$contentType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomResponseBody

        if (content != other.content) return false
        if (contentType != other.contentType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CustomResponseBody = Builder(this).apply(block).build()

    class Builder {
        /**
         * The payload of the custom response.
         *
         * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        var content: kotlin.String? = null
        /**
         * The type of content in the payload that you are defining in the `Content` string.
         */
        var contentType: aws.sdk.kotlin.services.wafv2.model.ResponseContentType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CustomResponseBody) : this() {
            this.content = x.content
            this.contentType = x.contentType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CustomResponseBody = CustomResponseBody(this)
    }
}
