// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The part of the web request that you want WAF to inspect. Include the single `FieldToMatch` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in `FieldToMatch` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.
 *
 * Example JSON for a `QueryString` field to match:
 *
 * ` "FieldToMatch": { "QueryString": {} }`
 *
 * Example JSON for a `Method` field to match specification:
 *
 * ` "FieldToMatch": { "Method": { "Name": "DELETE" } }`
 */
class FieldToMatch private constructor(builder: Builder) {
    /**
     * Inspect all query arguments.
     */
    val allQueryArguments: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments? = builder.allQueryArguments
    /**
     * Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
     *
     * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the `Body` object configuration.
     */
    val body: aws.sdk.kotlin.services.wafv2.model.Body? = builder.body
    /**
     * Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that WAF inspects.
     *
     * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
     */
    val cookies: aws.sdk.kotlin.services.wafv2.model.Cookies? = builder.cookies
    /**
     * Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that WAF inspects.
     *
     * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
     */
    val headers: aws.sdk.kotlin.services.wafv2.model.Headers? = builder.headers
    /**
     * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
     *
     * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
     */
    val jsonBody: aws.sdk.kotlin.services.wafv2.model.JsonBody? = builder.jsonBody
    /**
     * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    val method: aws.sdk.kotlin.services.wafv2.model.Method? = builder.method
    /**
     * Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    val queryString: aws.sdk.kotlin.services.wafv2.model.QueryString? = builder.queryString
    /**
     * Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer`. This setting isn't case sensitive.
     *
     * Example JSON: `"SingleHeader": { "Name": "haystack" }`
     *
     * Alternately, you can filter and inspect all headers with the `Headers``FieldToMatch` setting.
     */
    val singleHeader: aws.sdk.kotlin.services.wafv2.model.SingleHeader? = builder.singleHeader
    /**
     * Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion*. The name can be up to 30 characters long and isn't case sensitive.
     *
     * Example JSON: `"SingleQueryArgument": { "Name": "myArgument" }`
     */
    val singleQueryArgument: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument? = builder.singleQueryArgument
    /**
     * Inspect the request URI path. This is the part of the web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    val uriPath: aws.sdk.kotlin.services.wafv2.model.UriPath? = builder.uriPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FieldToMatch(")
        append("allQueryArguments=$allQueryArguments,")
        append("body=$body,")
        append("cookies=$cookies,")
        append("headers=$headers,")
        append("jsonBody=$jsonBody,")
        append("method=$method,")
        append("queryString=$queryString,")
        append("singleHeader=$singleHeader,")
        append("singleQueryArgument=$singleQueryArgument,")
        append("uriPath=$uriPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allQueryArguments?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (cookies?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (jsonBody?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (singleHeader?.hashCode() ?: 0)
        result = 31 * result + (singleQueryArgument?.hashCode() ?: 0)
        result = 31 * result + (uriPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FieldToMatch

        if (allQueryArguments != other.allQueryArguments) return false
        if (body != other.body) return false
        if (cookies != other.cookies) return false
        if (headers != other.headers) return false
        if (jsonBody != other.jsonBody) return false
        if (method != other.method) return false
        if (queryString != other.queryString) return false
        if (singleHeader != other.singleHeader) return false
        if (singleQueryArgument != other.singleQueryArgument) return false
        if (uriPath != other.uriPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = Builder(this).apply(block).build()

    class Builder {
        /**
         * Inspect all query arguments.
         */
        var allQueryArguments: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments? = null
        /**
         * Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         *
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the `Body` object configuration.
         */
        var body: aws.sdk.kotlin.services.wafv2.model.Body? = null
        /**
         * Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that WAF inspects.
         *
         * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
         */
        var cookies: aws.sdk.kotlin.services.wafv2.model.Cookies? = null
        /**
         * Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that WAF inspects.
         *
         * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
         */
        var headers: aws.sdk.kotlin.services.wafv2.model.Headers? = null
        /**
         * Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         *
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
         */
        var jsonBody: aws.sdk.kotlin.services.wafv2.model.JsonBody? = null
        /**
         * Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
         */
        var method: aws.sdk.kotlin.services.wafv2.model.Method? = null
        /**
         * Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
         */
        var queryString: aws.sdk.kotlin.services.wafv2.model.QueryString? = null
        /**
         * Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer`. This setting isn't case sensitive.
         *
         * Example JSON: `"SingleHeader": { "Name": "haystack" }`
         *
         * Alternately, you can filter and inspect all headers with the `Headers``FieldToMatch` setting.
         */
        var singleHeader: aws.sdk.kotlin.services.wafv2.model.SingleHeader? = null
        /**
         * Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion*. The name can be up to 30 characters long and isn't case sensitive.
         *
         * Example JSON: `"SingleQueryArgument": { "Name": "myArgument" }`
         */
        var singleQueryArgument: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument? = null
        /**
         * Inspect the request URI path. This is the part of the web request that identifies a resource, for example, `/images/daily-ad.jpg`.
         */
        var uriPath: aws.sdk.kotlin.services.wafv2.model.UriPath? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.FieldToMatch) : this() {
            this.allQueryArguments = x.allQueryArguments
            this.body = x.body
            this.cookies = x.cookies
            this.headers = x.headers
            this.jsonBody = x.jsonBody
            this.method = x.method
            this.queryString = x.queryString
            this.singleHeader = x.singleHeader
            this.singleQueryArgument = x.singleQueryArgument
            this.uriPath = x.uriPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = FieldToMatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AllQueryArguments] inside the given [block]
         */
        fun allQueryArguments(block: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments.Builder.() -> kotlin.Unit) {
            this.allQueryArguments = aws.sdk.kotlin.services.wafv2.model.AllQueryArguments.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Body] inside the given [block]
         */
        fun body(block: aws.sdk.kotlin.services.wafv2.model.Body.Builder.() -> kotlin.Unit) {
            this.body = aws.sdk.kotlin.services.wafv2.model.Body.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Cookies] inside the given [block]
         */
        fun cookies(block: aws.sdk.kotlin.services.wafv2.model.Cookies.Builder.() -> kotlin.Unit) {
            this.cookies = aws.sdk.kotlin.services.wafv2.model.Cookies.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Headers] inside the given [block]
         */
        fun headers(block: aws.sdk.kotlin.services.wafv2.model.Headers.Builder.() -> kotlin.Unit) {
            this.headers = aws.sdk.kotlin.services.wafv2.model.Headers.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.JsonBody] inside the given [block]
         */
        fun jsonBody(block: aws.sdk.kotlin.services.wafv2.model.JsonBody.Builder.() -> kotlin.Unit) {
            this.jsonBody = aws.sdk.kotlin.services.wafv2.model.JsonBody.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Method] inside the given [block]
         */
        fun method(block: aws.sdk.kotlin.services.wafv2.model.Method.Builder.() -> kotlin.Unit) {
            this.method = aws.sdk.kotlin.services.wafv2.model.Method.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.QueryString] inside the given [block]
         */
        fun queryString(block: aws.sdk.kotlin.services.wafv2.model.QueryString.Builder.() -> kotlin.Unit) {
            this.queryString = aws.sdk.kotlin.services.wafv2.model.QueryString.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SingleHeader] inside the given [block]
         */
        fun singleHeader(block: aws.sdk.kotlin.services.wafv2.model.SingleHeader.Builder.() -> kotlin.Unit) {
            this.singleHeader = aws.sdk.kotlin.services.wafv2.model.SingleHeader.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument] inside the given [block]
         */
        fun singleQueryArgument(block: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument.Builder.() -> kotlin.Unit) {
            this.singleQueryArgument = aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UriPath] inside the given [block]
         */
        fun uriPath(block: aws.sdk.kotlin.services.wafv2.model.UriPath.Builder.() -> kotlin.Unit) {
            this.uriPath = aws.sdk.kotlin.services.wafv2.model.UriPath.invoke(block)
        }
    }
}
