// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class GetRateBasedStatementManagedKeysRequest private constructor(builder: Builder) {
    /**
     * The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group.
     */
    val ruleGroupRuleName: kotlin.String? = builder.ruleGroupRuleName
    /**
     * The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter `RuleGroupRuleName`.
     */
    val ruleName: kotlin.String? = builder.ruleName
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    val webAclId: kotlin.String? = builder.webAclId
    /**
     * The name of the web ACL. You cannot change the name of a web ACL after you create it.
     */
    val webAclName: kotlin.String? = builder.webAclName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRateBasedStatementManagedKeysRequest(")
        append("ruleGroupRuleName=$ruleGroupRuleName,")
        append("ruleName=$ruleName,")
        append("scope=$scope,")
        append("webAclId=$webAclId,")
        append("webAclName=$webAclName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ruleGroupRuleName?.hashCode() ?: 0
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        result = 31 * result + (webAclName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRateBasedStatementManagedKeysRequest

        if (ruleGroupRuleName != other.ruleGroupRuleName) return false
        if (ruleName != other.ruleName) return false
        if (scope != other.scope) return false
        if (webAclId != other.webAclId) return false
        if (webAclName != other.webAclName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group.
         */
        var ruleGroupRuleName: kotlin.String? = null
        /**
         * The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter `RuleGroupRuleName`.
         */
        var ruleName: kotlin.String? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        var webAclId: kotlin.String? = null
        /**
         * The name of the web ACL. You cannot change the name of a web ACL after you create it.
         */
        var webAclName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysRequest) : this() {
            this.ruleGroupRuleName = x.ruleGroupRuleName
            this.ruleName = x.ruleName
            this.scope = x.scope
            this.webAclId = x.webAclId
            this.webAclName = x.webAclName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysRequest = GetRateBasedStatementManagedKeysRequest(this)
    }
}
