// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class GetSampledRequestsRequest private constructor(builder: Builder) {
    /**
     * The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of `MaxItems`, `GetSampledRequests` returns information about all of them.
     */
    val maxItems: kotlin.Long = builder.maxItems
    /**
     * The metric name assigned to the `Rule` or `RuleGroup` for which you want a sample of requests.
     */
    val ruleMetricName: kotlin.String? = builder.ruleMetricName
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * The start date and time and the end date and time of the range for which you want `GetSampledRequests` to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, `Z`. For example, `"2016-09-27T14:50Z"`. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.
     */
    val timeWindow: aws.sdk.kotlin.services.wafv2.model.TimeWindow? = builder.timeWindow
    /**
     * The Amazon resource name (ARN) of the `WebACL` for which you want a sample of requests.
     */
    val webAclArn: kotlin.String? = builder.webAclArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSampledRequestsRequest(")
        append("maxItems=$maxItems,")
        append("ruleMetricName=$ruleMetricName,")
        append("scope=$scope,")
        append("timeWindow=$timeWindow,")
        append("webAclArn=$webAclArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxItems.hashCode()
        result = 31 * result + (ruleMetricName?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (timeWindow?.hashCode() ?: 0)
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSampledRequestsRequest

        if (maxItems != other.maxItems) return false
        if (ruleMetricName != other.ruleMetricName) return false
        if (scope != other.scope) return false
        if (timeWindow != other.timeWindow) return false
        if (webAclArn != other.webAclArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of `MaxItems`, `GetSampledRequests` returns information about all of them.
         */
        var maxItems: kotlin.Long = 0L
        /**
         * The metric name assigned to the `Rule` or `RuleGroup` for which you want a sample of requests.
         */
        var ruleMetricName: kotlin.String? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * The start date and time and the end date and time of the range for which you want `GetSampledRequests` to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, `Z`. For example, `"2016-09-27T14:50Z"`. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.
         */
        var timeWindow: aws.sdk.kotlin.services.wafv2.model.TimeWindow? = null
        /**
         * The Amazon resource name (ARN) of the `WebACL` for which you want a sample of requests.
         */
        var webAclArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsRequest) : this() {
            this.maxItems = x.maxItems
            this.ruleMetricName = x.ruleMetricName
            this.scope = x.scope
            this.timeWindow = x.timeWindow
            this.webAclArn = x.webAclArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsRequest = GetSampledRequestsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.TimeWindow] inside the given [block]
         */
        fun timeWindow(block: aws.sdk.kotlin.services.wafv2.model.TimeWindow.Builder.() -> kotlin.Unit) {
            this.timeWindow = aws.sdk.kotlin.services.wafv2.model.TimeWindow.invoke(block)
        }
    }
}
