// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Inspect the headers in the web request. You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.
 *
 * This is used to indicate the web request component for WAF to inspect, in the FieldToMatch specification.
 *
 * Alternately, you can use the `SingleHeader``FieldToMatch` setting to inspect the value of a single header, identified by its key.
 *
 * Example JSON: `"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }`
 */
class Headers private constructor(builder: Builder) {
    /**
     * The filter to use to identify the subset of headers to inspect in a web request.
     *
     * You must specify exactly one setting: either `All`, `IncludedHeaders`, or `ExcludedHeaders`.
     *
     * Example JSON: `"HeaderMatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }`
     */
    val matchPattern: aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern? = builder.matchPattern
    /**
     * The parts of the headers to match with the rule inspection criteria. If you specify `All`, WAF inspects both keys and values.
     */
    val matchScope: aws.sdk.kotlin.services.wafv2.model.MapMatchScope? = builder.matchScope
    /**
     * What WAF should do if the headers of the request are larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF.
     *
     * The options for oversize handling are the following:
     * + `CONTINUE` - Inspect the headers normally, according to the rule inspection criteria.
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     */
    val oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = builder.oversizeHandling

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Headers = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Headers(")
        append("matchPattern=$matchPattern,")
        append("matchScope=$matchScope,")
        append("oversizeHandling=$oversizeHandling)")
    }

    override fun hashCode(): kotlin.Int {
        var result = matchPattern?.hashCode() ?: 0
        result = 31 * result + (matchScope?.hashCode() ?: 0)
        result = 31 * result + (oversizeHandling?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Headers

        if (matchPattern != other.matchPattern) return false
        if (matchScope != other.matchScope) return false
        if (oversizeHandling != other.oversizeHandling) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Headers = Builder(this).apply(block).build()

    class Builder {
        /**
         * The filter to use to identify the subset of headers to inspect in a web request.
         *
         * You must specify exactly one setting: either `All`, `IncludedHeaders`, or `ExcludedHeaders`.
         *
         * Example JSON: `"HeaderMatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }`
         */
        var matchPattern: aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern? = null
        /**
         * The parts of the headers to match with the rule inspection criteria. If you specify `All`, WAF inspects both keys and values.
         */
        var matchScope: aws.sdk.kotlin.services.wafv2.model.MapMatchScope? = null
        /**
         * What WAF should do if the headers of the request are larger than WAF can inspect. WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to WAF.
         *
         * The options for oversize handling are the following:
         * + `CONTINUE` - Inspect the headers normally, according to the rule inspection criteria.
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         */
        var oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Headers) : this() {
            this.matchPattern = x.matchPattern
            this.matchScope = x.matchScope
            this.oversizeHandling = x.oversizeHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Headers = Headers(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern] inside the given [block]
         */
        fun matchPattern(block: aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern.Builder.() -> kotlin.Unit) {
            this.matchPattern = aws.sdk.kotlin.services.wafv2.model.HeaderMatchPattern.invoke(block)
        }
    }
}
