// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Additional information that's used by a managed rule group. Most managed rule groups don't require this.
 *
 * Use this for the account takeover prevention managed rule group `AWSManagedRulesATPRuleSet`, to provide information about the sign-in page of your application.
 *
 * You can provide multiple individual `ManagedRuleGroupConfig` objects for any rule group configuration, for example `UsernameField` and `PasswordField`. The configuration that you provide depends on the needs of the managed rule group. For the ATP managed rule group, you provide the following individual configuration objects: `LoginPath`, `PasswordField`, `PayloadType` and `UsernameField`.
 */
class ManagedRuleGroupConfig private constructor(builder: Builder) {
    /**
     * The path of the login endpoint for your application. For example, for the URL `https://example.com/web/login`, you would provide the path `/web/login`.
     */
    val loginPath: kotlin.String? = builder.loginPath
    /**
     * Details about your login page password field.
     */
    val passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = builder.passwordField
    /**
     * The payload type for your login endpoint, either JSON or form encoded.
     */
    val payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = builder.payloadType
    /**
     * Details about your login page username field.
     */
    val usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = builder.usernameField

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleGroupConfig(")
        append("loginPath=$loginPath,")
        append("passwordField=$passwordField,")
        append("payloadType=$payloadType,")
        append("usernameField=$usernameField)")
    }

    override fun hashCode(): kotlin.Int {
        var result = loginPath?.hashCode() ?: 0
        result = 31 * result + (passwordField?.hashCode() ?: 0)
        result = 31 * result + (payloadType?.hashCode() ?: 0)
        result = 31 * result + (usernameField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleGroupConfig

        if (loginPath != other.loginPath) return false
        if (passwordField != other.passwordField) return false
        if (payloadType != other.payloadType) return false
        if (usernameField != other.usernameField) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The path of the login endpoint for your application. For example, for the URL `https://example.com/web/login`, you would provide the path `/web/login`.
         */
        var loginPath: kotlin.String? = null
        /**
         * Details about your login page password field.
         */
        var passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = null
        /**
         * The payload type for your login endpoint, either JSON or form encoded.
         */
        var payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = null
        /**
         * Details about your login page username field.
         */
        var usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig) : this() {
            this.loginPath = x.loginPath
            this.passwordField = x.passwordField
            this.payloadType = x.payloadType
            this.usernameField = x.usernameField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = ManagedRuleGroupConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.PasswordField] inside the given [block]
         */
        fun passwordField(block: aws.sdk.kotlin.services.wafv2.model.PasswordField.Builder.() -> kotlin.Unit) {
            this.passwordField = aws.sdk.kotlin.services.wafv2.model.PasswordField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UsernameField] inside the given [block]
         */
        fun usernameField(block: aws.sdk.kotlin.services.wafv2.model.UsernameField.Builder.() -> kotlin.Unit) {
            this.usernameField = aws.sdk.kotlin.services.wafv2.model.UsernameField.invoke(block)
        }
    }
}
