// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
 *
 * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. It can only be referenced as a top-level statement within a rule.
 */
class ManagedRuleGroupStatement private constructor(builder: Builder) {
    /**
     * The rules in the referenced rule group whose actions are set to `Count`. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were `Count`. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic.
     */
    val excludedRules: List<ExcludedRule>? = builder.excludedRules
    /**
     * Additional information that's used by a managed rule group. Most managed rule groups don't require this.
     *
     * Use this for the account takeover prevention managed rule group `AWSManagedRulesATPRuleSet`, to provide information about the sign-in page of your application.
     *
     * You can provide multiple individual `ManagedRuleGroupConfig` objects for any rule group configuration, for example `UsernameField` and `PasswordField`. The configuration that you provide depends on the needs of the managed rule group. For the ATP managed rule group, you provide the following individual configuration objects: `LoginPath`, `PasswordField`, `PayloadType` and `UsernameField`.
     */
    val managedRuleGroupConfigs: List<ManagedRuleGroupConfig>? = builder.managedRuleGroupConfigs
    /**
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    val name: kotlin.String? = builder.name
    /**
     * An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable Statement in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
     */
    val scopeDownStatement: aws.sdk.kotlin.services.wafv2.model.Statement? = builder.scopeDownStatement
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
     */
    val vendorName: kotlin.String? = builder.vendorName
    /**
     * The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleGroupStatement(")
        append("excludedRules=$excludedRules,")
        append("managedRuleGroupConfigs=$managedRuleGroupConfigs,")
        append("name=$name,")
        append("scopeDownStatement=$scopeDownStatement,")
        append("vendorName=$vendorName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludedRules?.hashCode() ?: 0
        result = 31 * result + (managedRuleGroupConfigs?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scopeDownStatement?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleGroupStatement

        if (excludedRules != other.excludedRules) return false
        if (managedRuleGroupConfigs != other.managedRuleGroupConfigs) return false
        if (name != other.name) return false
        if (scopeDownStatement != other.scopeDownStatement) return false
        if (vendorName != other.vendorName) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement = Builder(this).apply(block).build()

    class Builder {
        /**
         * The rules in the referenced rule group whose actions are set to `Count`. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were `Count`. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic.
         */
        var excludedRules: List<ExcludedRule>? = null
        /**
         * Additional information that's used by a managed rule group. Most managed rule groups don't require this.
         *
         * Use this for the account takeover prevention managed rule group `AWSManagedRulesATPRuleSet`, to provide information about the sign-in page of your application.
         *
         * You can provide multiple individual `ManagedRuleGroupConfig` objects for any rule group configuration, for example `UsernameField` and `PasswordField`. The configuration that you provide depends on the needs of the managed rule group. For the ATP managed rule group, you provide the following individual configuration objects: `LoginPath`, `PasswordField`, `PayloadType` and `UsernameField`.
         */
        var managedRuleGroupConfigs: List<ManagedRuleGroupConfig>? = null
        /**
         * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
         */
        var name: kotlin.String? = null
        /**
         * An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable Statement in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
         */
        var scopeDownStatement: aws.sdk.kotlin.services.wafv2.model.Statement? = null
        /**
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
         */
        var vendorName: kotlin.String? = null
        /**
         * The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement) : this() {
            this.excludedRules = x.excludedRules
            this.managedRuleGroupConfigs = x.managedRuleGroupConfigs
            this.name = x.name
            this.scopeDownStatement = x.scopeDownStatement
            this.vendorName = x.vendorName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement = ManagedRuleGroupStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Statement] inside the given [block]
         */
        fun scopeDownStatement(block: aws.sdk.kotlin.services.wafv2.model.Statement.Builder.() -> kotlin.Unit) {
            this.scopeDownStatement = aws.sdk.kotlin.services.wafv2.model.Statement.invoke(block)
        }
    }
}
