// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A set of rules that is managed by Amazon Web Services and Amazon Web Services Marketplace sellers to provide versioned managed rule groups for customers of WAF.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 */
class ManagedRuleSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A description of the set that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the managed rule set. The ID is returned in the responses to commands like `list`. You provide it to operations like `get` and `update`.
     */
    val id: kotlin.String? = builder.id
    /**
     * The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix.
     * + The syntax for the label namespace prefix for a managed rule group is the following: `awswaf:managed:<vendor>:<rule group name>`:
     * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
     */
    val labelNamespace: kotlin.String? = builder.labelNamespace
    /**
     * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
     *
     * This name is assigned to the corresponding managed rule group, which your customers can access and use.
     */
    val name: kotlin.String? = builder.name
    /**
     * The versions of this managed rule set that are available for use by customers.
     */
    val publishedVersions: Map<String, ManagedRuleSetVersion>? = builder.publishedVersions
    /**
     * The version that you would like your customers to use.
     */
    val recommendedVersion: kotlin.String? = builder.recommendedVersion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleSet(")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("labelNamespace=$labelNamespace,")
        append("name=$name,")
        append("publishedVersions=$publishedVersions,")
        append("recommendedVersion=$recommendedVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (labelNamespace?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (publishedVersions?.hashCode() ?: 0)
        result = 31 * result + (recommendedVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleSet

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (labelNamespace != other.labelNamespace) return false
        if (name != other.name) return false
        if (publishedVersions != other.publishedVersions) return false
        if (recommendedVersion != other.recommendedVersion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleSet = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        var arn: kotlin.String? = null
        /**
         * A description of the set that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier for the managed rule set. The ID is returned in the responses to commands like `list`. You provide it to operations like `get` and `update`.
         */
        var id: kotlin.String? = null
        /**
         * The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix.
         * + The syntax for the label namespace prefix for a managed rule group is the following: `awswaf:managed:<vendor>:<rule group name>`:
         * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
         */
        var labelNamespace: kotlin.String? = null
        /**
         * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
         *
         * This name is assigned to the corresponding managed rule group, which your customers can access and use.
         */
        var name: kotlin.String? = null
        /**
         * The versions of this managed rule set that are available for use by customers.
         */
        var publishedVersions: Map<String, ManagedRuleSetVersion>? = null
        /**
         * The version that you would like your customers to use.
         */
        var recommendedVersion: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleSet) : this() {
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.labelNamespace = x.labelNamespace
            this.name = x.name
            this.publishedVersions = x.publishedVersions
            this.recommendedVersion = x.recommendedVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleSet = ManagedRuleSet(this)
    }
}
