// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information for a release of the mobile SDK, including release notes and tags.
 *
 * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
 */
class MobileSdkRelease private constructor(builder: Builder) {
    /**
     * Notes describing the release.
     */
    val releaseNotes: kotlin.String? = builder.releaseNotes
    /**
     * The release version.
     */
    val releaseVersion: kotlin.String? = builder.releaseVersion
    /**
     * Tags that are associated with the release.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The timestamp of the release.
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.MobileSdkRelease = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MobileSdkRelease(")
        append("releaseNotes=$releaseNotes,")
        append("releaseVersion=$releaseVersion,")
        append("tags=$tags,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = releaseNotes?.hashCode() ?: 0
        result = 31 * result + (releaseVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MobileSdkRelease

        if (releaseNotes != other.releaseNotes) return false
        if (releaseVersion != other.releaseVersion) return false
        if (tags != other.tags) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.MobileSdkRelease = Builder(this).apply(block).build()

    class Builder {
        /**
         * Notes describing the release.
         */
        var releaseNotes: kotlin.String? = null
        /**
         * The release version.
         */
        var releaseVersion: kotlin.String? = null
        /**
         * Tags that are associated with the release.
         */
        var tags: List<Tag>? = null
        /**
         * The timestamp of the release.
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.MobileSdkRelease) : this() {
            this.releaseNotes = x.releaseNotes
            this.releaseVersion = x.releaseVersion
            this.tags = x.tags
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.MobileSdkRelease = MobileSdkRelease(this)
    }
}
