// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Contains one or more regular expressions.
 *
 * WAF assigns an ARN to each `RegexPatternSet` that you create. To use a set in a rule, you provide the ARN to the Rule statement RegexPatternSetReferenceStatement.
 */
class RegexPatternSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A description of the set that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the set. You cannot change the name after you create the set.
     */
    val name: kotlin.String? = builder.name
    /**
     * The regular expression patterns in the set.
     */
    val regularExpressionList: List<Regex>? = builder.regularExpressionList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RegexPatternSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexPatternSet(")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("regularExpressionList=$regularExpressionList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (regularExpressionList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexPatternSet

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (regularExpressionList != other.regularExpressionList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RegexPatternSet = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        var arn: kotlin.String? = null
        /**
         * A description of the set that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        var id: kotlin.String? = null
        /**
         * The name of the set. You cannot change the name after you create the set.
         */
        var name: kotlin.String? = null
        /**
         * The regular expression patterns in the set.
         */
        var regularExpressionList: List<Regex>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RegexPatternSet) : this() {
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.regularExpressionList = x.regularExpressionList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RegexPatternSet = RegexPatternSet(this)
    }
}
