// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
 *
 * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You can only use a rule group reference statement at the top level inside a web ACL.
 */
class RuleGroupReferenceStatement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The rules in the referenced rule group whose actions are set to `Count`. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were `Count`. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic.
     */
    val excludedRules: List<ExcludedRule>? = builder.excludedRules

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroupReferenceStatement(")
        append("arn=$arn,")
        append("excludedRules=$excludedRules)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (excludedRules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroupReferenceStatement

        if (arn != other.arn) return false
        if (excludedRules != other.excludedRules) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        var arn: kotlin.String? = null
        /**
         * The rules in the referenced rule group whose actions are set to `Count`. When you exclude a rule, WAF evaluates it exactly as it would if the rule action setting were `Count`. This is a useful option for testing the rules in a rule group without modifying how they handle your web traffic.
         */
        var excludedRules: List<ExcludedRule>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement) : this() {
            this.arn = x.arn
            this.excludedRules = x.excludedRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement = RuleGroupReferenceStatement(this)
    }
}
