// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a single sampled web request. The response from GetSampledRequests includes a `SampledHTTPRequests` complex type that appears as `SampledRequests` in the response syntax. `SampledHTTPRequests` contains an array of `SampledHTTPRequest` objects.
 */
class SampledHttpRequest private constructor(builder: Builder) {
    /**
     * The action for the `Rule` that the request matched: `Allow`, `Block`, or `Count`.
     */
    val action: kotlin.String? = builder.action
    /**
     * The `CAPTCHA` response for the request.
     */
    val captchaResponse: aws.sdk.kotlin.services.wafv2.model.CaptchaResponse? = builder.captchaResponse
    /**
     * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
     *
     * For example, `awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA` or `awswaf:managed:aws:managed-rule-set:header:encoding:utf8`.
     */
    val labels: List<Label>? = builder.labels
    /**
     * A complex type that contains detailed information about the request.
     */
    val request: aws.sdk.kotlin.services.wafv2.model.HttpRequest? = builder.request
    /**
     * Custom request headers inserted by WAF into the request, according to the custom request configuration for the matching rule action.
     */
    val requestHeadersInserted: List<HttpHeader>? = builder.requestHeadersInserted
    /**
     * The response code that was sent for the request.
     */
    val responseCodeSent: kotlin.Int? = builder.responseCodeSent
    /**
     * The name of the `Rule` that the request matched. For managed rule groups, the format for this name is `<vendor name>#<managed rule group name>#<rule name>`. For your own rule groups, the format for this name is `<rule group name>#<rule name>`. If the rule is not in a rule group, this field is absent.
     */
    val ruleNameWithinRuleGroup: kotlin.String? = builder.ruleNameWithinRuleGroup
    /**
     * The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in seconds).
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * A value that indicates how one result in the response relates proportionally to other results in the response. For example, a result that has a weight of `2` represents roughly twice as many web requests as a result that has a weight of `1`.
     */
    val weight: kotlin.Long = builder.weight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SampledHttpRequest(")
        append("action=$action,")
        append("captchaResponse=$captchaResponse,")
        append("labels=$labels,")
        append("request=$request,")
        append("requestHeadersInserted=$requestHeadersInserted,")
        append("responseCodeSent=$responseCodeSent,")
        append("ruleNameWithinRuleGroup=$ruleNameWithinRuleGroup,")
        append("timestamp=$timestamp,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (captchaResponse?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (request?.hashCode() ?: 0)
        result = 31 * result + (requestHeadersInserted?.hashCode() ?: 0)
        result = 31 * result + (responseCodeSent ?: 0)
        result = 31 * result + (ruleNameWithinRuleGroup?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (weight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SampledHttpRequest

        if (action != other.action) return false
        if (captchaResponse != other.captchaResponse) return false
        if (labels != other.labels) return false
        if (request != other.request) return false
        if (requestHeadersInserted != other.requestHeadersInserted) return false
        if (responseCodeSent != other.responseCodeSent) return false
        if (ruleNameWithinRuleGroup != other.ruleNameWithinRuleGroup) return false
        if (timestamp != other.timestamp) return false
        if (weight != other.weight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action for the `Rule` that the request matched: `Allow`, `Block`, or `Count`.
         */
        var action: kotlin.String? = null
        /**
         * The `CAPTCHA` response for the request.
         */
        var captchaResponse: aws.sdk.kotlin.services.wafv2.model.CaptchaResponse? = null
        /**
         * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
         *
         * For example, `awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA` or `awswaf:managed:aws:managed-rule-set:header:encoding:utf8`.
         */
        var labels: List<Label>? = null
        /**
         * A complex type that contains detailed information about the request.
         */
        var request: aws.sdk.kotlin.services.wafv2.model.HttpRequest? = null
        /**
         * Custom request headers inserted by WAF into the request, according to the custom request configuration for the matching rule action.
         */
        var requestHeadersInserted: List<HttpHeader>? = null
        /**
         * The response code that was sent for the request.
         */
        var responseCodeSent: kotlin.Int? = null
        /**
         * The name of the `Rule` that the request matched. For managed rule groups, the format for this name is `<vendor name>#<managed rule group name>#<rule name>`. For your own rule groups, the format for this name is `<rule group name>#<rule name>`. If the rule is not in a rule group, this field is absent.
         */
        var ruleNameWithinRuleGroup: kotlin.String? = null
        /**
         * The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in seconds).
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value that indicates how one result in the response relates proportionally to other results in the response. For example, a result that has a weight of `2` represents roughly twice as many web requests as a result that has a weight of `1`.
         */
        var weight: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest) : this() {
            this.action = x.action
            this.captchaResponse = x.captchaResponse
            this.labels = x.labels
            this.request = x.request
            this.requestHeadersInserted = x.requestHeadersInserted
            this.responseCodeSent = x.responseCodeSent
            this.ruleNameWithinRuleGroup = x.ruleNameWithinRuleGroup
            this.timestamp = x.timestamp
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest = SampledHttpRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CaptchaResponse] inside the given [block]
         */
        fun captchaResponse(block: aws.sdk.kotlin.services.wafv2.model.CaptchaResponse.Builder.() -> kotlin.Unit) {
            this.captchaResponse = aws.sdk.kotlin.services.wafv2.model.CaptchaResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.HttpRequest] inside the given [block]
         */
        fun request(block: aws.sdk.kotlin.services.wafv2.model.HttpRequest.Builder.() -> kotlin.Unit) {
            this.request = aws.sdk.kotlin.services.wafv2.model.HttpRequest.invoke(block)
        }
    }
}
