// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
 *
 * If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and block requests that have a request body greater than 8192 bytes.
 *
 * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
 */
class SizeConstraintStatement private constructor(builder: Builder) {
    /**
     * The operator to use to compare the request part to the size setting.
     */
    val comparisonOperator: aws.sdk.kotlin.services.wafv2.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * The part of the web request that you want WAF to inspect. For more information, see FieldToMatch.
     */
    val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * The size, in byte, to compare to the request part, after any transformations.
     */
    val size: kotlin.Long = builder.size
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
     */
    val textTransformations: List<TextTransformation>? = builder.textTransformations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SizeConstraintStatement(")
        append("comparisonOperator=$comparisonOperator,")
        append("fieldToMatch=$fieldToMatch,")
        append("size=$size,")
        append("textTransformations=$textTransformations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparisonOperator?.hashCode() ?: 0
        result = 31 * result + (fieldToMatch?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (textTransformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SizeConstraintStatement

        if (comparisonOperator != other.comparisonOperator) return false
        if (fieldToMatch != other.fieldToMatch) return false
        if (size != other.size) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement = Builder(this).apply(block).build()

    class Builder {
        /**
         * The operator to use to compare the request part to the size setting.
         */
        var comparisonOperator: aws.sdk.kotlin.services.wafv2.model.ComparisonOperator? = null
        /**
         * The part of the web request that you want WAF to inspect. For more information, see FieldToMatch.
         */
        var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * The size, in byte, to compare to the request part, after any transformations.
         */
        var size: kotlin.Long = 0L
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
         */
        var textTransformations: List<TextTransformation>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement) : this() {
            this.comparisonOperator = x.comparisonOperator
            this.fieldToMatch = x.fieldToMatch
            this.size = x.size
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement = SizeConstraintStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }
    }
}
