// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The processing guidance for a Rule, used by WAF to determine whether a web request matches the rule.
 */
class Statement private constructor(builder: Builder) {
    /**
     * A logical rule statement used to combine other rule statements with AND logic. You provide more than one Statement within the `AndStatement`.
     */
    val andStatement: aws.sdk.kotlin.services.wafv2.model.AndStatement? = builder.andStatement
    /**
     * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is refered to as a string match statement.
     */
    val byteMatchStatement: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement? = builder.byteMatchStatement
    /**
     * A rule statement used to identify web requests based on country of origin.
     */
    val geoMatchStatement: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement? = builder.geoMatchStatement
    /**
     * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an IPSet that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see CreateIPSet.
     *
     * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
     */
    val ipSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement? = builder.ipSetReferenceStatement
    /**
     * A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL.
     *
     * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement.
     */
    val labelMatchStatement: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement? = builder.labelMatchStatement
    /**
     * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
     *
     * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. It can only be referenced as a top-level statement within a rule.
     */
    val managedRuleGroupStatement: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement? = builder.managedRuleGroupStatement
    /**
     * A logical rule statement used to negate the results of another rule statement. You provide one Statement within the `NotStatement`.
     */
    val notStatement: aws.sdk.kotlin.services.wafv2.model.NotStatement? = builder.notStatement
    /**
     * A logical rule statement used to combine other rule statements with OR logic. You provide more than one Statement within the `OrStatement`.
     */
    val orStatement: aws.sdk.kotlin.services.wafv2.model.OrStatement? = builder.orStatement
    /**
     * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
     *
     * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
     *
     * When the rule action triggers, WAF blocks additional requests from the IP address until the request rate falls below the limit.
     *
     * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
     * + An IP match statement with an IP set that specified the address 192.0.2.44.
     * + A string match statement that searches in the User-Agent header for the string BadBot.
     *
     * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate limit and are not affected by this rule.
     *
     * You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement`. You can define a `RateBasedStatement` inside a web ACL and inside a rule group.
     */
    val rateBasedStatement: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement? = builder.rateBasedStatement
    /**
     * A rule statement used to search web request components for a match against a single regular expression.
     */
    val regexMatchStatement: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement? = builder.regexMatchStatement
    /**
     * A rule statement used to search web request components for matches with regular expressions. To use this, create a RegexPatternSet that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see CreateRegexPatternSet.
     *
     * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
     */
    val regexPatternSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement? = builder.regexPatternSetReferenceStatement
    /**
     * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
     *
     * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You can only use a rule group reference statement at the top level inside a web ACL.
     */
    val ruleGroupReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement? = builder.ruleGroupReferenceStatement
    /**
     * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
     *
     * If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and block requests that have a request body greater than 8192 bytes.
     *
     * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
     */
    val sizeConstraintStatement: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement? = builder.sizeConstraintStatement
    /**
     * Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your database. To allow or block web requests that appear to contain malicious SQL code, create one or more SQL injection match conditions. An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want WAF to inspect. Later in the process, when you create a web ACL, you specify whether to allow or block requests that appear to contain malicious SQL code.
     */
    val sqliMatchStatement: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement? = builder.sqliMatchStatement
    /**
     * A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the location in requests that you want WAF to search and text transformations to use on the search area before WAF searches for character sequences that are likely to be malicious strings.
     */
    val xssMatchStatement: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement? = builder.xssMatchStatement

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Statement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Statement(")
        append("andStatement=$andStatement,")
        append("byteMatchStatement=$byteMatchStatement,")
        append("geoMatchStatement=$geoMatchStatement,")
        append("ipSetReferenceStatement=$ipSetReferenceStatement,")
        append("labelMatchStatement=$labelMatchStatement,")
        append("managedRuleGroupStatement=$managedRuleGroupStatement,")
        append("notStatement=$notStatement,")
        append("orStatement=$orStatement,")
        append("rateBasedStatement=$rateBasedStatement,")
        append("regexMatchStatement=$regexMatchStatement,")
        append("regexPatternSetReferenceStatement=$regexPatternSetReferenceStatement,")
        append("ruleGroupReferenceStatement=$ruleGroupReferenceStatement,")
        append("sizeConstraintStatement=$sizeConstraintStatement,")
        append("sqliMatchStatement=$sqliMatchStatement,")
        append("xssMatchStatement=$xssMatchStatement)")
    }

    override fun hashCode(): kotlin.Int {
        var result = andStatement?.hashCode() ?: 0
        result = 31 * result + (byteMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (geoMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (ipSetReferenceStatement?.hashCode() ?: 0)
        result = 31 * result + (labelMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (managedRuleGroupStatement?.hashCode() ?: 0)
        result = 31 * result + (notStatement?.hashCode() ?: 0)
        result = 31 * result + (orStatement?.hashCode() ?: 0)
        result = 31 * result + (rateBasedStatement?.hashCode() ?: 0)
        result = 31 * result + (regexMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (regexPatternSetReferenceStatement?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupReferenceStatement?.hashCode() ?: 0)
        result = 31 * result + (sizeConstraintStatement?.hashCode() ?: 0)
        result = 31 * result + (sqliMatchStatement?.hashCode() ?: 0)
        result = 31 * result + (xssMatchStatement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Statement

        if (andStatement != other.andStatement) return false
        if (byteMatchStatement != other.byteMatchStatement) return false
        if (geoMatchStatement != other.geoMatchStatement) return false
        if (ipSetReferenceStatement != other.ipSetReferenceStatement) return false
        if (labelMatchStatement != other.labelMatchStatement) return false
        if (managedRuleGroupStatement != other.managedRuleGroupStatement) return false
        if (notStatement != other.notStatement) return false
        if (orStatement != other.orStatement) return false
        if (rateBasedStatement != other.rateBasedStatement) return false
        if (regexMatchStatement != other.regexMatchStatement) return false
        if (regexPatternSetReferenceStatement != other.regexPatternSetReferenceStatement) return false
        if (ruleGroupReferenceStatement != other.ruleGroupReferenceStatement) return false
        if (sizeConstraintStatement != other.sizeConstraintStatement) return false
        if (sqliMatchStatement != other.sqliMatchStatement) return false
        if (xssMatchStatement != other.xssMatchStatement) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Statement = Builder(this).apply(block).build()

    class Builder {
        /**
         * A logical rule statement used to combine other rule statements with AND logic. You provide more than one Statement within the `AndStatement`.
         */
        var andStatement: aws.sdk.kotlin.services.wafv2.model.AndStatement? = null
        /**
         * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is refered to as a string match statement.
         */
        var byteMatchStatement: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement? = null
        /**
         * A rule statement used to identify web requests based on country of origin.
         */
        var geoMatchStatement: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement? = null
        /**
         * A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an IPSet that specifies the addresses you want to detect, then use the ARN of that set in this statement. To create an IP set, see CreateIPSet.
         *
         * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
         */
        var ipSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement? = null
        /**
         * A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL.
         *
         * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement.
         */
        var labelMatchStatement: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement? = null
        /**
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
         *
         * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. It can only be referenced as a top-level statement within a rule.
         */
        var managedRuleGroupStatement: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement? = null
        /**
         * A logical rule statement used to negate the results of another rule statement. You provide one Statement within the `NotStatement`.
         */
        var notStatement: aws.sdk.kotlin.services.wafv2.model.NotStatement? = null
        /**
         * A logical rule statement used to combine other rule statements with OR logic. You provide more than one Statement within the `OrStatement`.
         */
        var orStatement: aws.sdk.kotlin.services.wafv2.model.OrStatement? = null
        /**
         * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
         *
         * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
         *
         * When the rule action triggers, WAF blocks additional requests from the IP address until the request rate falls below the limit.
         *
         * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
         * + An IP match statement with an IP set that specified the address 192.0.2.44.
         * + A string match statement that searches in the User-Agent header for the string BadBot.
         *
         * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate limit and are not affected by this rule.
         *
         * You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement`. You can define a `RateBasedStatement` inside a web ACL and inside a rule group.
         */
        var rateBasedStatement: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement? = null
        /**
         * A rule statement used to search web request components for a match against a single regular expression.
         */
        var regexMatchStatement: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement? = null
        /**
         * A rule statement used to search web request components for matches with regular expressions. To use this, create a RegexPatternSet that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. To create a regex pattern set, see CreateRegexPatternSet.
         *
         * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, WAF automatically updates all rules that reference it.
         */
        var regexPatternSetReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement? = null
        /**
         * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
         *
         * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You can only use a rule group reference statement at the top level inside a web ACL.
         */
        var ruleGroupReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement? = null
        /**
         * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
         *
         * If you configure WAF to inspect the request body, WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you can create a size constraint condition and block requests that have a request body greater than 8192 bytes.
         *
         * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
         */
        var sizeConstraintStatement: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement? = null
        /**
         * Attackers sometimes insert malicious SQL code into web requests in an effort to extract data from your database. To allow or block web requests that appear to contain malicious SQL code, create one or more SQL injection match conditions. An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want WAF to inspect. Later in the process, when you create a web ACL, you specify whether to allow or block requests that appear to contain malicious SQL code.
         */
        var sqliMatchStatement: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement? = null
        /**
         * A rule statement that defines a cross-site scripting (XSS) match search for WAF to apply to web requests. XSS attacks are those where the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers. The XSS match statement provides the location in requests that you want WAF to search and text transformations to use on the search area before WAF searches for character sequences that are likely to be malicious strings.
         */
        var xssMatchStatement: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Statement) : this() {
            this.andStatement = x.andStatement
            this.byteMatchStatement = x.byteMatchStatement
            this.geoMatchStatement = x.geoMatchStatement
            this.ipSetReferenceStatement = x.ipSetReferenceStatement
            this.labelMatchStatement = x.labelMatchStatement
            this.managedRuleGroupStatement = x.managedRuleGroupStatement
            this.notStatement = x.notStatement
            this.orStatement = x.orStatement
            this.rateBasedStatement = x.rateBasedStatement
            this.regexMatchStatement = x.regexMatchStatement
            this.regexPatternSetReferenceStatement = x.regexPatternSetReferenceStatement
            this.ruleGroupReferenceStatement = x.ruleGroupReferenceStatement
            this.sizeConstraintStatement = x.sizeConstraintStatement
            this.sqliMatchStatement = x.sqliMatchStatement
            this.xssMatchStatement = x.xssMatchStatement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Statement = Statement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AndStatement] inside the given [block]
         */
        fun andStatement(block: aws.sdk.kotlin.services.wafv2.model.AndStatement.Builder.() -> kotlin.Unit) {
            this.andStatement = aws.sdk.kotlin.services.wafv2.model.AndStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement] inside the given [block]
         */
        fun byteMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement.Builder.() -> kotlin.Unit) {
            this.byteMatchStatement = aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement] inside the given [block]
         */
        fun geoMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement.Builder.() -> kotlin.Unit) {
            this.geoMatchStatement = aws.sdk.kotlin.services.wafv2.model.GeoMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement] inside the given [block]
         */
        fun ipSetReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement.Builder.() -> kotlin.Unit) {
            this.ipSetReferenceStatement = aws.sdk.kotlin.services.wafv2.model.IpSetReferenceStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement] inside the given [block]
         */
        fun labelMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement.Builder.() -> kotlin.Unit) {
            this.labelMatchStatement = aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement] inside the given [block]
         */
        fun managedRuleGroupStatement(block: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement.Builder.() -> kotlin.Unit) {
            this.managedRuleGroupStatement = aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.NotStatement] inside the given [block]
         */
        fun notStatement(block: aws.sdk.kotlin.services.wafv2.model.NotStatement.Builder.() -> kotlin.Unit) {
            this.notStatement = aws.sdk.kotlin.services.wafv2.model.NotStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.OrStatement] inside the given [block]
         */
        fun orStatement(block: aws.sdk.kotlin.services.wafv2.model.OrStatement.Builder.() -> kotlin.Unit) {
            this.orStatement = aws.sdk.kotlin.services.wafv2.model.OrStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RateBasedStatement] inside the given [block]
         */
        fun rateBasedStatement(block: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement.Builder.() -> kotlin.Unit) {
            this.rateBasedStatement = aws.sdk.kotlin.services.wafv2.model.RateBasedStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement] inside the given [block]
         */
        fun regexMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement.Builder.() -> kotlin.Unit) {
            this.regexMatchStatement = aws.sdk.kotlin.services.wafv2.model.RegexMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement] inside the given [block]
         */
        fun regexPatternSetReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement.Builder.() -> kotlin.Unit) {
            this.regexPatternSetReferenceStatement = aws.sdk.kotlin.services.wafv2.model.RegexPatternSetReferenceStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement] inside the given [block]
         */
        fun ruleGroupReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement.Builder.() -> kotlin.Unit) {
            this.ruleGroupReferenceStatement = aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement] inside the given [block]
         */
        fun sizeConstraintStatement(block: aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement.Builder.() -> kotlin.Unit) {
            this.sizeConstraintStatement = aws.sdk.kotlin.services.wafv2.model.SizeConstraintStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement] inside the given [block]
         */
        fun sqliMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement.Builder.() -> kotlin.Unit) {
            this.sqliMatchStatement = aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.XssMatchStatement] inside the given [block]
         */
        fun xssMatchStatement(block: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement.Builder.() -> kotlin.Unit) {
            this.xssMatchStatement = aws.sdk.kotlin.services.wafv2.model.XssMatchStatement.invoke(block)
        }
    }
}
