// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The collection of tagging definitions for an Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing or other management. Typically, the tag key represents a category, such as "environment", and the tag value represents a specific value within that category, such as "test," "development," or "production". Or you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 *
 * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
 */
class TagInfoForResource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The array of Tag objects defined for the resource.
     */
    val tagList: List<Tag>? = builder.tagList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.TagInfoForResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagInfoForResource(")
        append("resourceArn=$resourceArn,")
        append("tagList=$tagList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tagList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagInfoForResource

        if (resourceArn != other.resourceArn) return false
        if (tagList != other.tagList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.TagInfoForResource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        var resourceArn: kotlin.String? = null
        /**
         * The array of Tag objects defined for the resource.
         */
        var tagList: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.TagInfoForResource) : this() {
            this.resourceArn = x.resourceArn
            this.tagList = x.tagList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.TagInfoForResource = TagInfoForResource(this)
    }
}
