// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.GetMobileSdkReleaseResponse
import aws.sdk.kotlin.services.wafv2.model.MobileSdkRelease
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMobileSdkReleaseOperationDeserializer: HttpDeserialize<GetMobileSdkReleaseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMobileSdkReleaseResponse {
        if (!response.status.isSuccess()) {
            throwGetMobileSdkReleaseError(context, response)
        }
        val builder = GetMobileSdkReleaseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMobileSdkReleaseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMobileSdkReleaseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMobileSdkReleaseOperationBody(builder: GetMobileSdkReleaseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MOBILESDKRELEASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MobileSdkRelease"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MOBILESDKRELEASE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MOBILESDKRELEASE_DESCRIPTOR.index -> builder.mobileSdkRelease = deserializeMobileSdkReleaseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
