// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.UpdateWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateWebACLOperationDeserializer: HttpDeserialize<UpdateWebAclResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateWebAclResponse {
        if (!response.status.isSuccess()) {
            throwUpdateWebAclError(context, response)
        }
        val builder = UpdateWebAclResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateWebACLOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateWebAclError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFConfigurationWarningException" -> WafConfigurationWarningExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFDuplicateItemException" -> WafDuplicateItemExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFExpiredManagedRuleGroupVersionException" -> WafExpiredManagedRuleGroupVersionExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidResourceException" -> WafInvalidResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFOptimisticLockException" -> WafOptimisticLockExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFSubscriptionNotFoundException" -> WafSubscriptionNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFUnavailableEntityException" -> WafUnavailableEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateWebACLOperationBody(builder: UpdateWebAclResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTLOCKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextLockToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTLOCKTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTLOCKTOKEN_DESCRIPTOR.index -> builder.nextLockToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
