// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.wafv2.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.wafv2.endpoints.EndpointProvider
import aws.sdk.kotlin.services.wafv2.model.*
import aws.sdk.kotlin.services.wafv2.model.AssociateWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.AssociateWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.CheckCapacityRequest
import aws.sdk.kotlin.services.wafv2.model.CheckCapacityResponse
import aws.sdk.kotlin.services.wafv2.model.CreateIpSetRequest
import aws.sdk.kotlin.services.wafv2.model.CreateIpSetResponse
import aws.sdk.kotlin.services.wafv2.model.CreateRegexPatternSetRequest
import aws.sdk.kotlin.services.wafv2.model.CreateRegexPatternSetResponse
import aws.sdk.kotlin.services.wafv2.model.CreateRuleGroupRequest
import aws.sdk.kotlin.services.wafv2.model.CreateRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.CreateWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.CreateWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
import aws.sdk.kotlin.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse
import aws.sdk.kotlin.services.wafv2.model.DeleteIpSetRequest
import aws.sdk.kotlin.services.wafv2.model.DeleteIpSetResponse
import aws.sdk.kotlin.services.wafv2.model.DeleteLoggingConfigurationRequest
import aws.sdk.kotlin.services.wafv2.model.DeleteLoggingConfigurationResponse
import aws.sdk.kotlin.services.wafv2.model.DeletePermissionPolicyRequest
import aws.sdk.kotlin.services.wafv2.model.DeletePermissionPolicyResponse
import aws.sdk.kotlin.services.wafv2.model.DeleteRegexPatternSetRequest
import aws.sdk.kotlin.services.wafv2.model.DeleteRegexPatternSetResponse
import aws.sdk.kotlin.services.wafv2.model.DeleteRuleGroupRequest
import aws.sdk.kotlin.services.wafv2.model.DeleteRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.DeleteWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.DeleteWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupRequest
import aws.sdk.kotlin.services.wafv2.model.DescribeManagedRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.DisassociateWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.DisassociateWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.GenerateMobileSdkReleaseUrlRequest
import aws.sdk.kotlin.services.wafv2.model.GenerateMobileSdkReleaseUrlResponse
import aws.sdk.kotlin.services.wafv2.model.GetIpSetRequest
import aws.sdk.kotlin.services.wafv2.model.GetIpSetResponse
import aws.sdk.kotlin.services.wafv2.model.GetLoggingConfigurationRequest
import aws.sdk.kotlin.services.wafv2.model.GetLoggingConfigurationResponse
import aws.sdk.kotlin.services.wafv2.model.GetManagedRuleSetRequest
import aws.sdk.kotlin.services.wafv2.model.GetManagedRuleSetResponse
import aws.sdk.kotlin.services.wafv2.model.GetMobileSdkReleaseRequest
import aws.sdk.kotlin.services.wafv2.model.GetMobileSdkReleaseResponse
import aws.sdk.kotlin.services.wafv2.model.GetPermissionPolicyRequest
import aws.sdk.kotlin.services.wafv2.model.GetPermissionPolicyResponse
import aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysRequest
import aws.sdk.kotlin.services.wafv2.model.GetRateBasedStatementManagedKeysResponse
import aws.sdk.kotlin.services.wafv2.model.GetRegexPatternSetRequest
import aws.sdk.kotlin.services.wafv2.model.GetRegexPatternSetResponse
import aws.sdk.kotlin.services.wafv2.model.GetRuleGroupRequest
import aws.sdk.kotlin.services.wafv2.model.GetRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsRequest
import aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse
import aws.sdk.kotlin.services.wafv2.model.GetWebAclForResourceRequest
import aws.sdk.kotlin.services.wafv2.model.GetWebAclForResourceResponse
import aws.sdk.kotlin.services.wafv2.model.GetWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.GetWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
import aws.sdk.kotlin.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
import aws.sdk.kotlin.services.wafv2.model.ListAvailableManagedRuleGroupsRequest
import aws.sdk.kotlin.services.wafv2.model.ListAvailableManagedRuleGroupsResponse
import aws.sdk.kotlin.services.wafv2.model.ListIpSetsRequest
import aws.sdk.kotlin.services.wafv2.model.ListIpSetsResponse
import aws.sdk.kotlin.services.wafv2.model.ListLoggingConfigurationsRequest
import aws.sdk.kotlin.services.wafv2.model.ListLoggingConfigurationsResponse
import aws.sdk.kotlin.services.wafv2.model.ListManagedRuleSetsRequest
import aws.sdk.kotlin.services.wafv2.model.ListManagedRuleSetsResponse
import aws.sdk.kotlin.services.wafv2.model.ListMobileSdkReleasesRequest
import aws.sdk.kotlin.services.wafv2.model.ListMobileSdkReleasesResponse
import aws.sdk.kotlin.services.wafv2.model.ListRegexPatternSetsRequest
import aws.sdk.kotlin.services.wafv2.model.ListRegexPatternSetsResponse
import aws.sdk.kotlin.services.wafv2.model.ListResourcesForWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.ListResourcesForWebAclResponse
import aws.sdk.kotlin.services.wafv2.model.ListRuleGroupsRequest
import aws.sdk.kotlin.services.wafv2.model.ListRuleGroupsResponse
import aws.sdk.kotlin.services.wafv2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.wafv2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.wafv2.model.ListWebAcLsRequest
import aws.sdk.kotlin.services.wafv2.model.ListWebAcLsResponse
import aws.sdk.kotlin.services.wafv2.model.PutLoggingConfigurationRequest
import aws.sdk.kotlin.services.wafv2.model.PutLoggingConfigurationResponse
import aws.sdk.kotlin.services.wafv2.model.PutManagedRuleSetVersionsRequest
import aws.sdk.kotlin.services.wafv2.model.PutManagedRuleSetVersionsResponse
import aws.sdk.kotlin.services.wafv2.model.PutPermissionPolicyRequest
import aws.sdk.kotlin.services.wafv2.model.PutPermissionPolicyResponse
import aws.sdk.kotlin.services.wafv2.model.TagResourceRequest
import aws.sdk.kotlin.services.wafv2.model.TagResourceResponse
import aws.sdk.kotlin.services.wafv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.wafv2.model.UntagResourceResponse
import aws.sdk.kotlin.services.wafv2.model.UpdateIpSetRequest
import aws.sdk.kotlin.services.wafv2.model.UpdateIpSetResponse
import aws.sdk.kotlin.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateRequest
import aws.sdk.kotlin.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
import aws.sdk.kotlin.services.wafv2.model.UpdateRegexPatternSetRequest
import aws.sdk.kotlin.services.wafv2.model.UpdateRegexPatternSetResponse
import aws.sdk.kotlin.services.wafv2.model.UpdateRuleGroupRequest
import aws.sdk.kotlin.services.wafv2.model.UpdateRuleGroupResponse
import aws.sdk.kotlin.services.wafv2.model.UpdateWebAclRequest
import aws.sdk.kotlin.services.wafv2.model.UpdateWebAclResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # WAF
 * This is the latest version of the **WAF** API, released in November, 2019. The names of the entities that you use to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2", to distinguish from the prior version. We recommend migrating your resources to this version, because it has a number of significant improvements.
 *
 * If you used WAF prior to this release, you can't use this WAFV2 API to access any WAF resources that you created before. You can access your old rules, web ACLs, and other WAF resources only through the WAF Classic APIs. The WAF Classic APIs have retained the prior names, endpoints, and namespaces.
 *
 * For information, including how to migrate your WAF resources to this version, see the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
 *
 * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to Amazon CloudFront, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, or an Amazon Cognito user pool. WAF also lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, the Amazon API Gateway REST API, CloudFront distribution, the Application Load Balancer, the AppSync GraphQL API, or the Amazon Cognito user pool responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You also can configure CloudFront to return a custom error page when a request is blocked.
 *
 * This API guide is for developers who need detailed information about WAF API actions, data types, and errors. For detailed information about WAF features and an overview of how to use WAF, see the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
 *
 * You can make calls using the endpoints listed in [WAF endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/waf.html).
 * + For regional applications, you can use any of the endpoints in the list. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
 * + For Amazon CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.
 *
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](http://aws.amazon.com/tools/#SDKs).
 *
 * We currently provide two versions of the WAF API: this API and the prior versions, the classic WAF APIs. This new API provides the same functionality as the older versions, with the following major improvements:
 * + You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a `Scope` parameter and set it to `CLOUDFRONT` or `REGIONAL`.
 * + You can define a web ACL or rule group with a single call, and update it with a single call. You define all rule specifications in JSON format, and pass them to your rule group or web ACL calls.
 * + The limits WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule groups include capacity settings, so you know the maximum cost of a rule group when you use it.
 */
public interface Wafv2Client : SdkClient {

    override val serviceName: String
        get() = "WAFV2"
    /**
     * Wafv2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Wafv2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultWafv2Client(config)
        }

        public operator fun invoke(config: Config): Wafv2Client = DefaultWafv2Client(config)

        /**
         * Construct a [Wafv2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Wafv2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultWafv2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "WAFV2")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
     *
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call `UpdateDistribution`, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    public suspend fun associateWebAcl(input: AssociateWebAclRequest): AssociateWebAclResponse

    /**
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a RuleGroup or WebACL.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    public suspend fun checkCapacity(input: CheckCapacityRequest): CheckCapacityResponse

    /**
     * Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.
     */
    public suspend fun createIpSet(input: CreateIpSetRequest): CreateIpSetResponse

    /**
     * Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.
     */
    public suspend fun createRegexPatternSet(input: CreateRegexPatternSetRequest): CreateRegexPatternSetResponse

    /**
     * Creates a RuleGroup per the specifications provided.
     *
     *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
     */
    public suspend fun createRuleGroup(input: CreateRuleGroupRequest): CreateRuleGroupResponse

    /**
     * Creates a WebACL per the specifications provided.
     *
     *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, or an Amazon Cognito user pool.
     */
    public suspend fun createWebAcl(input: CreateWebAclRequest): CreateWebAclResponse

    /**
     * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
     *
     * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
     */
    public suspend fun deleteFirewallManagerRuleGroups(input: DeleteFirewallManagerRuleGroupsRequest): DeleteFirewallManagerRuleGroupsResponse

    /**
     * Deletes the specified IPSet.
     */
    public suspend fun deleteIpSet(input: DeleteIpSetRequest): DeleteIpSetResponse

    /**
     * Deletes the LoggingConfiguration from the specified web ACL.
     */
    public suspend fun deleteLoggingConfiguration(input: DeleteLoggingConfigurationRequest): DeleteLoggingConfigurationResponse

    /**
     * Permanently deletes an IAM policy from the specified rule group.
     *
     * You must be the owner of the rule group to perform this operation.
     */
    public suspend fun deletePermissionPolicy(input: DeletePermissionPolicyRequest): DeletePermissionPolicyResponse

    /**
     * Deletes the specified RegexPatternSet.
     */
    public suspend fun deleteRegexPatternSet(input: DeleteRegexPatternSetRequest): DeleteRegexPatternSetResponse

    /**
     * Deletes the specified RuleGroup.
     */
    public suspend fun deleteRuleGroup(input: DeleteRuleGroupRequest): DeleteRuleGroupResponse

    /**
     * Deletes the specified WebACL.
     *
     * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
     *
     * Before deleting any web ACL, first disassociate it from all resources.
     * + To retrieve a list of the resources that are associated with a web ACL, use the following calls:
     *    + For regional resources, call ListResourcesForWebACL.
     *    + For Amazon CloudFront distributions, use the CloudFront call `ListDistributionsByWebACLId`. For information, see [ListDistributionsByWebACLId](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html).
     * + To disassociate a resource from a web ACL, use the following calls:
     *    + For regional resources, call DisassociateWebACL.
     *    + For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     */
    public suspend fun deleteWebAcl(input: DeleteWebAclRequest): DeleteWebAclResponse

    /**
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     */
    public suspend fun describeManagedRuleGroup(input: DescribeManagedRuleGroupRequest): DescribeManagedRuleGroupResponse

    /**
     * Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
     *
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     */
    public suspend fun disassociateWebAcl(input: DisassociateWebAclRequest): DisassociateWebAclResponse

    /**
     * Generates a presigned download URL for the specified release of the mobile SDK.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    public suspend fun generateMobileSdkReleaseUrl(input: GenerateMobileSdkReleaseUrlRequest): GenerateMobileSdkReleaseUrlResponse

    /**
     * Retrieves the specified IPSet.
     */
    public suspend fun getIpSet(input: GetIpSetRequest): GetIpSetResponse

    /**
     * Returns the LoggingConfiguration for the specified web ACL.
     */
    public suspend fun getLoggingConfiguration(input: GetLoggingConfigurationRequest): GetLoggingConfigurationResponse

    /**
     * Retrieves the specified managed rule set.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    public suspend fun getManagedRuleSet(input: GetManagedRuleSetRequest): GetManagedRuleSetResponse

    /**
     * Retrieves information for the specified mobile SDK release, including release notes and tags.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    public suspend fun getMobileSdkRelease(input: GetMobileSdkReleaseRequest): GetMobileSdkReleaseResponse

    /**
     * Returns the IAM policy that is attached to the specified rule group.
     *
     * You must be the owner of the rule group to perform this operation.
     */
    public suspend fun getPermissionPolicy(input: GetPermissionPolicyRequest): GetPermissionPolicyResponse

    /**
     * Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
     *
     * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name.
     *
     * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first.
     */
    public suspend fun getRateBasedStatementManagedKeys(input: GetRateBasedStatementManagedKeysRequest): GetRateBasedStatementManagedKeysResponse

    /**
     * Retrieves the specified RegexPatternSet.
     */
    public suspend fun getRegexPatternSet(input: GetRegexPatternSetRequest): GetRegexPatternSetResponse

    /**
     * Retrieves the specified RuleGroup.
     */
    public suspend fun getRuleGroup(input: GetRuleGroupRequest = GetRuleGroupRequest {}): GetRuleGroupResponse

    /**
     * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     *
     * `GetSampledRequests` returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, `GetSampledRequests` returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.
     */
    public suspend fun getSampledRequests(input: GetSampledRequestsRequest): GetSampledRequestsResponse

    /**
     * Retrieves the specified WebACL.
     */
    public suspend fun getWebAcl(input: GetWebAclRequest): GetWebAclResponse

    /**
     * Retrieves the WebACL for the specified resource.
     */
    public suspend fun getWebAclForResource(input: GetWebAclForResourceRequest): GetWebAclForResourceResponse

    /**
     * Returns a list of the available versions for the specified managed rule group.
     */
    public suspend fun listAvailableManagedRuleGroupVersions(input: ListAvailableManagedRuleGroupVersionsRequest): ListAvailableManagedRuleGroupVersionsResponse

    /**
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.
     */
    public suspend fun listAvailableManagedRuleGroups(input: ListAvailableManagedRuleGroupsRequest): ListAvailableManagedRuleGroupsResponse

    /**
     * Retrieves an array of IPSetSummary objects for the IP sets that you manage.
     */
    public suspend fun listIpSets(input: ListIpSetsRequest): ListIpSetsResponse

    /**
     * Retrieves an array of your LoggingConfiguration objects.
     */
    public suspend fun listLoggingConfigurations(input: ListLoggingConfigurationsRequest): ListLoggingConfigurationsResponse

    /**
     * Retrieves the managed rule sets that you own.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    public suspend fun listManagedRuleSets(input: ListManagedRuleSetsRequest): ListManagedRuleSetsResponse

    /**
     * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    public suspend fun listMobileSdkReleases(input: ListMobileSdkReleasesRequest): ListMobileSdkReleasesResponse

    /**
     * Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage.
     */
    public suspend fun listRegexPatternSets(input: ListRegexPatternSetsRequest): ListRegexPatternSetsResponse

    /**
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call `ListDistributionsByWebACLId`.
     */
    public suspend fun listResourcesForWebAcl(input: ListResourcesForWebAclRequest): ListResourcesForWebAclResponse

    /**
     * Retrieves an array of RuleGroupSummary objects for the rule groups that you manage.
     */
    public suspend fun listRuleGroups(input: ListRuleGroupsRequest): ListRuleGroupsResponse

    /**
     * Retrieves the TagInfoForResource for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves an array of WebACLSummary objects for the web ACLs that you manage.
     */
    public suspend fun listWebAcLs(input: ListWebAcLsRequest): ListWebAcLsResponse

    /**
     * Enables the specified LoggingConfiguration, to start logging from a web ACL, according to the configuration provided.
     *
     * You can define one logging destination per web ACL.
     *
     * You can access information about the traffic that WAF inspects using the following steps:
     * + Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. The name that you give the destination must start with `aws-waf-logs-`. Depending on the type of destination, you might need to configure additional settings or permissions. For configuration requirements and pricing information for each destination type, see [Logging web ACL traffic](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
     * + Associate your logging destination to your web ACL using a `PutLoggingConfiguration` request.
     *
     * When you successfully enable logging using a `PutLoggingConfiguration` request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
     *
     * For additional information about web ACL logging, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
     *
     * This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling GetLoggingConfiguration, update the settings as needed, and then provide the complete logging configuration specification to this call.
     */
    public suspend fun putLoggingConfiguration(input: PutLoggingConfigurationRequest): PutLoggingConfigurationResponse

    /**
     * Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     *
     * Customers retrieve their managed rule group list by calling ListAvailableManagedRuleGroups. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling ListAvailableManagedRuleGroupVersions. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using.
     *
     * To initiate the expiration of a managed rule group version, use UpdateManagedRuleSetVersionExpiryDate.
     */
    public suspend fun putManagedRuleSetVersions(input: PutManagedRuleSetVersionsRequest): PutManagedRuleSetVersionsResponse

    /**
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     *
     * You must be the owner of the rule group to perform this operation.
     *
     * This action is subject to the following restrictions:
     * + You can attach only one policy with each `PutPermissionPolicy` request.
     * + The ARN in the request must be a valid WAF RuleGroup ARN and the rule group must exist in the same Region.
     * + The user making the request must be the owner of the rule group.
     */
    public suspend fun putPermissionPolicy(input: PutPermissionPolicyRequest): PutPermissionPolicyResponse

    /**
     * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified IPSet.
     *
     * This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling GetIPSet, update the settings as needed, and then provide the complete IP set specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    public suspend fun updateIpSet(input: UpdateIpSetRequest): UpdateIpSetResponse

    /**
     * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the response to ListAvailableManagedRuleGroupVersions for the managed rule group.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    public suspend fun updateManagedRuleSetVersionExpiryDate(input: UpdateManagedRuleSetVersionExpiryDateRequest): UpdateManagedRuleSetVersionExpiryDateResponse

    /**
     * Updates the specified RegexPatternSet.
     *
     * This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling GetRegexPatternSet, update the settings as needed, and then provide the complete regex pattern set specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    public suspend fun updateRegexPatternSet(input: UpdateRegexPatternSetRequest): UpdateRegexPatternSetResponse

    /**
     * Updates the specified RuleGroup.
     *
     * This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling GetRuleGroup, update the settings as needed, and then provide the complete rule group specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     *
     *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
     */
    public suspend fun updateRuleGroup(input: UpdateRuleGroupRequest): UpdateRuleGroupResponse

    /**
     * Updates the specified WebACL. While updating a web ACL, WAF provides continuous coverage to the resources that you have associated with the web ACL.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     *
     * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling GetWebACL, update the settings as needed, and then provide the complete web ACL specification to this call.
     *
     *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, or an Amazon Cognito user pool.
     */
    public suspend fun updateWebAcl(input: UpdateWebAclRequest): UpdateWebAclResponse
}

/**
 * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
 *
 * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call `UpdateDistribution`, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
 *
 * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
 */
public suspend inline fun Wafv2Client.associateWebAcl(crossinline block: AssociateWebAclRequest.Builder.() -> Unit): AssociateWebAclResponse = associateWebAcl(AssociateWebAclRequest.Builder().apply(block).build())

/**
 * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a RuleGroup or WebACL.
 *
 * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
 */
public suspend inline fun Wafv2Client.checkCapacity(crossinline block: CheckCapacityRequest.Builder.() -> Unit): CheckCapacityResponse = checkCapacity(CheckCapacityRequest.Builder().apply(block).build())

/**
 * Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.
 */
public suspend inline fun Wafv2Client.createIpSet(crossinline block: CreateIpSetRequest.Builder.() -> Unit): CreateIpSetResponse = createIpSet(CreateIpSetRequest.Builder().apply(block).build())

/**
 * Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.
 */
public suspend inline fun Wafv2Client.createRegexPatternSet(crossinline block: CreateRegexPatternSetRequest.Builder.() -> Unit): CreateRegexPatternSetResponse = createRegexPatternSet(CreateRegexPatternSetRequest.Builder().apply(block).build())

/**
 * Creates a RuleGroup per the specifications provided.
 *
 *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
 */
public suspend inline fun Wafv2Client.createRuleGroup(crossinline block: CreateRuleGroupRequest.Builder.() -> Unit): CreateRuleGroupResponse = createRuleGroup(CreateRuleGroupRequest.Builder().apply(block).build())

/**
 * Creates a WebACL per the specifications provided.
 *
 *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, or an Amazon Cognito user pool.
 */
public suspend inline fun Wafv2Client.createWebAcl(crossinline block: CreateWebAclRequest.Builder.() -> Unit): CreateWebAclResponse = createWebAcl(CreateWebAclRequest.Builder().apply(block).build())

/**
 * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
 *
 * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
 */
public suspend inline fun Wafv2Client.deleteFirewallManagerRuleGroups(crossinline block: DeleteFirewallManagerRuleGroupsRequest.Builder.() -> Unit): DeleteFirewallManagerRuleGroupsResponse = deleteFirewallManagerRuleGroups(DeleteFirewallManagerRuleGroupsRequest.Builder().apply(block).build())

/**
 * Deletes the specified IPSet.
 */
public suspend inline fun Wafv2Client.deleteIpSet(crossinline block: DeleteIpSetRequest.Builder.() -> Unit): DeleteIpSetResponse = deleteIpSet(DeleteIpSetRequest.Builder().apply(block).build())

/**
 * Deletes the LoggingConfiguration from the specified web ACL.
 */
public suspend inline fun Wafv2Client.deleteLoggingConfiguration(crossinline block: DeleteLoggingConfigurationRequest.Builder.() -> Unit): DeleteLoggingConfigurationResponse = deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Permanently deletes an IAM policy from the specified rule group.
 *
 * You must be the owner of the rule group to perform this operation.
 */
public suspend inline fun Wafv2Client.deletePermissionPolicy(crossinline block: DeletePermissionPolicyRequest.Builder.() -> Unit): DeletePermissionPolicyResponse = deletePermissionPolicy(DeletePermissionPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified RegexPatternSet.
 */
public suspend inline fun Wafv2Client.deleteRegexPatternSet(crossinline block: DeleteRegexPatternSetRequest.Builder.() -> Unit): DeleteRegexPatternSetResponse = deleteRegexPatternSet(DeleteRegexPatternSetRequest.Builder().apply(block).build())

/**
 * Deletes the specified RuleGroup.
 */
public suspend inline fun Wafv2Client.deleteRuleGroup(crossinline block: DeleteRuleGroupRequest.Builder.() -> Unit): DeleteRuleGroupResponse = deleteRuleGroup(DeleteRuleGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified WebACL.
 *
 * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
 *
 * Before deleting any web ACL, first disassociate it from all resources.
 * + To retrieve a list of the resources that are associated with a web ACL, use the following calls:
 *    + For regional resources, call ListResourcesForWebACL.
 *    + For Amazon CloudFront distributions, use the CloudFront call `ListDistributionsByWebACLId`. For information, see [ListDistributionsByWebACLId](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html).
 * + To disassociate a resource from a web ACL, use the following calls:
 *    + For regional resources, call DisassociateWebACL.
 *    + For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
 */
public suspend inline fun Wafv2Client.deleteWebAcl(crossinline block: DeleteWebAclRequest.Builder.() -> Unit): DeleteWebAclResponse = deleteWebAcl(DeleteWebAclRequest.Builder().apply(block).build())

/**
 * Provides high-level information for a managed rule group, including descriptions of the rules.
 */
public suspend inline fun Wafv2Client.describeManagedRuleGroup(crossinline block: DescribeManagedRuleGroupRequest.Builder.() -> Unit): DescribeManagedRuleGroupResponse = describeManagedRuleGroup(DescribeManagedRuleGroupRequest.Builder().apply(block).build())

/**
 * Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.
 *
 * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
 */
public suspend inline fun Wafv2Client.disassociateWebAcl(crossinline block: DisassociateWebAclRequest.Builder.() -> Unit): DisassociateWebAclResponse = disassociateWebAcl(DisassociateWebAclRequest.Builder().apply(block).build())

/**
 * Generates a presigned download URL for the specified release of the mobile SDK.
 *
 * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
 */
public suspend inline fun Wafv2Client.generateMobileSdkReleaseUrl(crossinline block: GenerateMobileSdkReleaseUrlRequest.Builder.() -> Unit): GenerateMobileSdkReleaseUrlResponse = generateMobileSdkReleaseUrl(GenerateMobileSdkReleaseUrlRequest.Builder().apply(block).build())

/**
 * Retrieves the specified IPSet.
 */
public suspend inline fun Wafv2Client.getIpSet(crossinline block: GetIpSetRequest.Builder.() -> Unit): GetIpSetResponse = getIpSet(GetIpSetRequest.Builder().apply(block).build())

/**
 * Returns the LoggingConfiguration for the specified web ACL.
 */
public suspend inline fun Wafv2Client.getLoggingConfiguration(crossinline block: GetLoggingConfigurationRequest.Builder.() -> Unit): GetLoggingConfigurationResponse = getLoggingConfiguration(GetLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the specified managed rule set.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 */
public suspend inline fun Wafv2Client.getManagedRuleSet(crossinline block: GetManagedRuleSetRequest.Builder.() -> Unit): GetManagedRuleSetResponse = getManagedRuleSet(GetManagedRuleSetRequest.Builder().apply(block).build())

/**
 * Retrieves information for the specified mobile SDK release, including release notes and tags.
 *
 * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
 */
public suspend inline fun Wafv2Client.getMobileSdkRelease(crossinline block: GetMobileSdkReleaseRequest.Builder.() -> Unit): GetMobileSdkReleaseResponse = getMobileSdkRelease(GetMobileSdkReleaseRequest.Builder().apply(block).build())

/**
 * Returns the IAM policy that is attached to the specified rule group.
 *
 * You must be the owner of the rule group to perform this operation.
 */
public suspend inline fun Wafv2Client.getPermissionPolicy(crossinline block: GetPermissionPolicyRequest.Builder.() -> Unit): GetPermissionPolicyResponse = getPermissionPolicy(GetPermissionPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
 *
 * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name.
 *
 * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first.
 */
public suspend inline fun Wafv2Client.getRateBasedStatementManagedKeys(crossinline block: GetRateBasedStatementManagedKeysRequest.Builder.() -> Unit): GetRateBasedStatementManagedKeysResponse = getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest.Builder().apply(block).build())

/**
 * Retrieves the specified RegexPatternSet.
 */
public suspend inline fun Wafv2Client.getRegexPatternSet(crossinline block: GetRegexPatternSetRequest.Builder.() -> Unit): GetRegexPatternSetResponse = getRegexPatternSet(GetRegexPatternSetRequest.Builder().apply(block).build())

/**
 * Retrieves the specified RuleGroup.
 */
public suspend inline fun Wafv2Client.getRuleGroup(crossinline block: GetRuleGroupRequest.Builder.() -> Unit): GetRuleGroupResponse = getRuleGroup(GetRuleGroupRequest.Builder().apply(block).build())

/**
 * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
 *
 * `GetSampledRequests` returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, `GetSampledRequests` returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.
 */
public suspend inline fun Wafv2Client.getSampledRequests(crossinline block: GetSampledRequestsRequest.Builder.() -> Unit): GetSampledRequestsResponse = getSampledRequests(GetSampledRequestsRequest.Builder().apply(block).build())

/**
 * Retrieves the specified WebACL.
 */
public suspend inline fun Wafv2Client.getWebAcl(crossinline block: GetWebAclRequest.Builder.() -> Unit): GetWebAclResponse = getWebAcl(GetWebAclRequest.Builder().apply(block).build())

/**
 * Retrieves the WebACL for the specified resource.
 */
public suspend inline fun Wafv2Client.getWebAclForResource(crossinline block: GetWebAclForResourceRequest.Builder.() -> Unit): GetWebAclForResourceResponse = getWebAclForResource(GetWebAclForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of the available versions for the specified managed rule group.
 */
public suspend inline fun Wafv2Client.listAvailableManagedRuleGroupVersions(crossinline block: ListAvailableManagedRuleGroupVersionsRequest.Builder.() -> Unit): ListAvailableManagedRuleGroupVersionsResponse = listAvailableManagedRuleGroupVersions(ListAvailableManagedRuleGroupVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.
 */
public suspend inline fun Wafv2Client.listAvailableManagedRuleGroups(crossinline block: ListAvailableManagedRuleGroupsRequest.Builder.() -> Unit): ListAvailableManagedRuleGroupsResponse = listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves an array of IPSetSummary objects for the IP sets that you manage.
 */
public suspend inline fun Wafv2Client.listIpSets(crossinline block: ListIpSetsRequest.Builder.() -> Unit): ListIpSetsResponse = listIpSets(ListIpSetsRequest.Builder().apply(block).build())

/**
 * Retrieves an array of your LoggingConfiguration objects.
 */
public suspend inline fun Wafv2Client.listLoggingConfigurations(crossinline block: ListLoggingConfigurationsRequest.Builder.() -> Unit): ListLoggingConfigurationsResponse = listLoggingConfigurations(ListLoggingConfigurationsRequest.Builder().apply(block).build())

/**
 * Retrieves the managed rule sets that you own.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 */
public suspend inline fun Wafv2Client.listManagedRuleSets(crossinline block: ListManagedRuleSetsRequest.Builder.() -> Unit): ListManagedRuleSetsResponse = listManagedRuleSets(ListManagedRuleSetsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
 *
 * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage WAF tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
 */
public suspend inline fun Wafv2Client.listMobileSdkReleases(crossinline block: ListMobileSdkReleasesRequest.Builder.() -> Unit): ListMobileSdkReleasesResponse = listMobileSdkReleases(ListMobileSdkReleasesRequest.Builder().apply(block).build())

/**
 * Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage.
 */
public suspend inline fun Wafv2Client.listRegexPatternSets(crossinline block: ListRegexPatternSetsRequest.Builder.() -> Unit): ListRegexPatternSetsResponse = listRegexPatternSets(ListRegexPatternSetsRequest.Builder().apply(block).build())

/**
 * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call `ListDistributionsByWebACLId`.
 */
public suspend inline fun Wafv2Client.listResourcesForWebAcl(crossinline block: ListResourcesForWebAclRequest.Builder.() -> Unit): ListResourcesForWebAclResponse = listResourcesForWebAcl(ListResourcesForWebAclRequest.Builder().apply(block).build())

/**
 * Retrieves an array of RuleGroupSummary objects for the rule groups that you manage.
 */
public suspend inline fun Wafv2Client.listRuleGroups(crossinline block: ListRuleGroupsRequest.Builder.() -> Unit): ListRuleGroupsResponse = listRuleGroups(ListRuleGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves the TagInfoForResource for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 *
 * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
 */
public suspend inline fun Wafv2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves an array of WebACLSummary objects for the web ACLs that you manage.
 */
public suspend inline fun Wafv2Client.listWebAcLs(crossinline block: ListWebAcLsRequest.Builder.() -> Unit): ListWebAcLsResponse = listWebAcLs(ListWebAcLsRequest.Builder().apply(block).build())

/**
 * Enables the specified LoggingConfiguration, to start logging from a web ACL, according to the configuration provided.
 *
 * You can define one logging destination per web ACL.
 *
 * You can access information about the traffic that WAF inspects using the following steps:
 * + Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. The name that you give the destination must start with `aws-waf-logs-`. Depending on the type of destination, you might need to configure additional settings or permissions. For configuration requirements and pricing information for each destination type, see [Logging web ACL traffic](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
 * + Associate your logging destination to your web ACL using a `PutLoggingConfiguration` request.
 *
 * When you successfully enable logging using a `PutLoggingConfiguration` request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
 *
 * For additional information about web ACL logging, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
 *
 * This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling GetLoggingConfiguration, update the settings as needed, and then provide the complete logging configuration specification to this call.
 */
public suspend inline fun Wafv2Client.putLoggingConfiguration(crossinline block: PutLoggingConfigurationRequest.Builder.() -> Unit): PutLoggingConfigurationResponse = putLoggingConfiguration(PutLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 *
 * Customers retrieve their managed rule group list by calling ListAvailableManagedRuleGroups. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling ListAvailableManagedRuleGroupVersions. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using.
 *
 * To initiate the expiration of a managed rule group version, use UpdateManagedRuleSetVersionExpiryDate.
 */
public suspend inline fun Wafv2Client.putManagedRuleSetVersions(crossinline block: PutManagedRuleSetVersionsRequest.Builder.() -> Unit): PutManagedRuleSetVersionsResponse = putManagedRuleSetVersions(PutManagedRuleSetVersionsRequest.Builder().apply(block).build())

/**
 * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
 *
 * You must be the owner of the rule group to perform this operation.
 *
 * This action is subject to the following restrictions:
 * + You can attach only one policy with each `PutPermissionPolicy` request.
 * + The ARN in the request must be a valid WAF RuleGroup ARN and the rule group must exist in the same Region.
 * + The user making the request must be the owner of the rule group.
 */
public suspend inline fun Wafv2Client.putPermissionPolicy(crossinline block: PutPermissionPolicyRequest.Builder.() -> Unit): PutPermissionPolicyResponse = putPermissionPolicy(PutPermissionPolicyRequest.Builder().apply(block).build())

/**
 * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
 *
 * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
 */
public suspend inline fun Wafv2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.
 */
public suspend inline fun Wafv2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified IPSet.
 *
 * This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling GetIPSet, update the settings as needed, and then provide the complete IP set specification to this call.
 *
 * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
 */
public suspend inline fun Wafv2Client.updateIpSet(crossinline block: UpdateIpSetRequest.Builder.() -> Unit): UpdateIpSetResponse = updateIpSet(UpdateIpSetRequest.Builder().apply(block).build())

/**
 * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the response to ListAvailableManagedRuleGroupVersions for the managed rule group.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 */
public suspend inline fun Wafv2Client.updateManagedRuleSetVersionExpiryDate(crossinline block: UpdateManagedRuleSetVersionExpiryDateRequest.Builder.() -> Unit): UpdateManagedRuleSetVersionExpiryDateResponse = updateManagedRuleSetVersionExpiryDate(UpdateManagedRuleSetVersionExpiryDateRequest.Builder().apply(block).build())

/**
 * Updates the specified RegexPatternSet.
 *
 * This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling GetRegexPatternSet, update the settings as needed, and then provide the complete regex pattern set specification to this call.
 *
 * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
 */
public suspend inline fun Wafv2Client.updateRegexPatternSet(crossinline block: UpdateRegexPatternSetRequest.Builder.() -> Unit): UpdateRegexPatternSetResponse = updateRegexPatternSet(UpdateRegexPatternSetRequest.Builder().apply(block).build())

/**
 * Updates the specified RuleGroup.
 *
 * This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling GetRuleGroup, update the settings as needed, and then provide the complete rule group specification to this call.
 *
 * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
 *
 *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
 */
public suspend inline fun Wafv2Client.updateRuleGroup(crossinline block: UpdateRuleGroupRequest.Builder.() -> Unit): UpdateRuleGroupResponse = updateRuleGroup(UpdateRuleGroupRequest.Builder().apply(block).build())

/**
 * Updates the specified WebACL. While updating a web ACL, WAF provides continuous coverage to the resources that you have associated with the web ACL.
 *
 * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
 *
 * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling GetWebACL, update the settings as needed, and then provide the complete web ACL specification to this call.
 *
 *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, an AppSync GraphQL API, or an Amazon Cognito user pool.
 */
public suspend inline fun Wafv2Client.updateWebAcl(crossinline block: UpdateWebAclRequest.Builder.() -> Unit): UpdateWebAclResponse = updateWebAcl(UpdateWebAclRequest.Builder().apply(block).build())
