// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Inspect the body of the web request. The body immediately follows the request headers.
 *
 * This is used to indicate the web request component to inspect, in the FieldToMatch specification.
 */
public class Body private constructor(builder: Builder) {
    /**
     * What WAF should do if the body is larger than WAF can inspect. WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to WAF by the underlying host service.
     *
     * The options for oversize handling are the following:
     * + `CONTINUE` - Inspect the body normally, according to the rule inspection criteria.
     * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * + `NO_MATCH` - Treat the web request as not matching the rule statement.
     *
     * You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.
     *
     * Default: `CONTINUE`
     */
    public val oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = builder.oversizeHandling

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.Body = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Body(")
        append("oversizeHandling=$oversizeHandling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = oversizeHandling?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Body

        if (oversizeHandling != other.oversizeHandling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.Body = Builder(this).apply(block).build()

    public class Builder {
        /**
         * What WAF should do if the body is larger than WAF can inspect. WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to WAF by the underlying host service.
         *
         * The options for oversize handling are the following:
         * + `CONTINUE` - Inspect the body normally, according to the rule inspection criteria.
         * + `MATCH` - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * + `NO_MATCH` - Treat the web request as not matching the rule statement.
         *
         * You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.
         *
         * Default: `CONTINUE`
         */
        public var oversizeHandling: aws.sdk.kotlin.services.wafv2.model.OversizeHandling? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.Body) : this() {
            this.oversizeHandling = x.oversizeHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.Body = Body(this)
    }
}
