// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Specifies that WAF should run a `Challenge` check against the request to verify that the request is coming from a legitimate client session:
 * + If the request includes a valid, unexpired challenge token, WAF applies any custom request handling and labels that you've configured and then allows the web request inspection to proceed to the next rule, similar to a `CountAction`.
 * + If the request doesn't include a valid, unexpired challenge token, WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.WAF then generates a challenge response that it sends back to the client, which includes the following:
 *    + The header `x-amzn-waf-action` with a value of `challenge`.
 *    + The HTTP status code `202 Request Accepted`.
 *    + If the request contains an `Accept` header with a value of `text/html`, the response includes a JavaScript page interstitial with a challenge script.
 * Challenges run silent browser interrogations in the background, and don't generally affect the end user experience. A challenge enforces token acquisition using an interstitial JavaScript challenge that inspects the client session for legitimate behavior. The challenge blocks bots or at least increases the cost of operating sophisticated bots. After the client session successfully responds to the challenge, it receives a new token from WAF, which the challenge script uses to resubmit the original request.
 *
 * You can configure the expiration time in the `ChallengeConfig``ImmunityTimeProperty` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
 *
 * This action option is available for rules. It isn't available for web ACL default actions.
 */
public class ChallengeAction private constructor(builder: Builder) {
    /**
     * Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    public val customRequestHandling: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling? = builder.customRequestHandling

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ChallengeAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChallengeAction(")
        append("customRequestHandling=$customRequestHandling")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customRequestHandling?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChallengeAction

        if (customRequestHandling != other.customRequestHandling) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ChallengeAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        public var customRequestHandling: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ChallengeAction) : this() {
            this.customRequestHandling = x.customRequestHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ChallengeAction = ChallengeAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling] inside the given [block]
         */
        public fun customRequestHandling(block: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling.Builder.() -> kotlin.Unit) {
            this.customRequestHandling = aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling.invoke(block)
        }
    }
}
