// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Custom request handling behavior that inserts custom headers into a web request. You can add custom request handling for WAF to use when the rule action doesn't block the request. For example, `CaptchaAction` for requests with valid t okens, and `AllowAction`.
 *
 * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
 */
public class CustomRequestHandling private constructor(builder: Builder) {
    /**
     * The HTTP headers to insert into the request. Duplicate header names are not allowed.
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    public val insertHeaders: List<CustomHttpHeader>? = builder.insertHeaders

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomRequestHandling(")
        append("insertHeaders=$insertHeaders")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = insertHeaders?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomRequestHandling

        if (insertHeaders != other.insertHeaders) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The HTTP headers to insert into the request. Duplicate header names are not allowed.
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        public var insertHeaders: List<CustomHttpHeader>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling) : this() {
            this.insertHeaders = x.insertHeaders
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling = CustomRequestHandling(this)
    }
}
