// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The processing guidance for an Firewall Manager rule. This is like a regular rule Statement, but it can only contain a rule group reference.
 */
public class FirewallManagerStatement private constructor(builder: Builder) {
    /**
     * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
     *
     * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. It can only be referenced as a top-level statement within a rule.
     *
     * You are charged additional fees when you use the WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet` or the WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet`. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
     */
    public val managedRuleGroupStatement: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement? = builder.managedRuleGroupStatement
    /**
     * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
     *
     * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You can only use a rule group reference statement at the top level inside a web ACL.
     */
    public val ruleGroupReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement? = builder.ruleGroupReferenceStatement

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallManagerStatement(")
        append("managedRuleGroupStatement=$managedRuleGroupStatement,")
        append("ruleGroupReferenceStatement=$ruleGroupReferenceStatement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = managedRuleGroupStatement?.hashCode() ?: 0
        result = 31 * result + (ruleGroupReferenceStatement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallManagerStatement

        if (managedRuleGroupStatement != other.managedRuleGroupStatement) return false
        if (ruleGroupReferenceStatement != other.ruleGroupReferenceStatement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
         *
         * You cannot nest a `ManagedRuleGroupStatement`, for example for use inside a `NotStatement` or `OrStatement`. It can only be referenced as a top-level statement within a rule.
         *
         * You are charged additional fees when you use the WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet` or the WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet`. For more information, see [WAF Pricing](http://aws.amazon.com/waf/pricing/).
         */
        public var managedRuleGroupStatement: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement? = null
        /**
         * A rule statement used to run the rules that are defined in a RuleGroup. To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
         *
         * You cannot nest a `RuleGroupReferenceStatement`, for example for use inside a `NotStatement` or `OrStatement`. You can only use a rule group reference statement at the top level inside a web ACL.
         */
        public var ruleGroupReferenceStatement: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement) : this() {
            this.managedRuleGroupStatement = x.managedRuleGroupStatement
            this.ruleGroupReferenceStatement = x.ruleGroupReferenceStatement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement = FirewallManagerStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement] inside the given [block]
         */
        public fun managedRuleGroupStatement(block: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement.Builder.() -> kotlin.Unit) {
            this.managedRuleGroupStatement = aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement] inside the given [block]
         */
        public fun ruleGroupReferenceStatement(block: aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement.Builder.() -> kotlin.Unit) {
            this.ruleGroupReferenceStatement = aws.sdk.kotlin.services.wafv2.model.RuleGroupReferenceStatement.invoke(block)
        }
    }
}
