// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Part of the response from GetSampledRequests. This is a complex type that appears as `Request` in the response syntax. `HTTPRequest` contains information about one of the web requests.
 */
public class HttpRequest private constructor(builder: Builder) {
    /**
     * The IP address that the request originated from. If the web ACL is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:
     * + `c-ip`, if the viewer did not use an HTTP proxy or a load balancer to send the request
     * + `x-forwarded-for`, if the viewer did use an HTTP proxy or a load balancer to send the request
     */
    public val clientIp: kotlin.String? = builder.clientIp
    /**
     * The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
     */
    public val country: kotlin.String? = builder.country
    /**
     * A complex type that contains the name and value for each header in the sampled web request.
     */
    public val headers: List<HttpHeader>? = builder.headers
    /**
     * The HTTP version specified in the sampled web request, for example, `HTTP/1.1`.
     */
    public val httpVersion: kotlin.String? = builder.httpVersion
    /**
     * The HTTP method specified in the sampled web request.
     */
    public val method: kotlin.String? = builder.method
    /**
     * The URI path of the request, which identifies the resource, for example, `/images/daily-ad.jpg`.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.HttpRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpRequest(")
        append("clientIp=$clientIp,")
        append("country=$country,")
        append("headers=$headers,")
        append("httpVersion=$httpVersion,")
        append("method=$method,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIp?.hashCode() ?: 0
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (httpVersion?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpRequest

        if (clientIp != other.clientIp) return false
        if (country != other.country) return false
        if (headers != other.headers) return false
        if (httpVersion != other.httpVersion) return false
        if (method != other.method) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.HttpRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IP address that the request originated from. If the web ACL is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:
         * + `c-ip`, if the viewer did not use an HTTP proxy or a load balancer to send the request
         * + `x-forwarded-for`, if the viewer did use an HTTP proxy or a load balancer to send the request
         */
        public var clientIp: kotlin.String? = null
        /**
         * The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
         */
        public var country: kotlin.String? = null
        /**
         * A complex type that contains the name and value for each header in the sampled web request.
         */
        public var headers: List<HttpHeader>? = null
        /**
         * The HTTP version specified in the sampled web request, for example, `HTTP/1.1`.
         */
        public var httpVersion: kotlin.String? = null
        /**
         * The HTTP method specified in the sampled web request.
         */
        public var method: kotlin.String? = null
        /**
         * The URI path of the request, which identifies the resource, for example, `/images/daily-ad.jpg`.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.HttpRequest) : this() {
            this.clientIp = x.clientIp
            this.country = x.country
            this.headers = x.headers
            this.httpVersion = x.httpVersion
            this.method = x.method
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.HttpRequest = HttpRequest(this)
    }
}
