// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.
 *
 * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, WAF performs the search for labels that were added in the same context as the label match statement.
 */
public class LabelMatchStatement private constructor(builder: Builder) {
    /**
     * The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:
     * + If the `Scope` indicates `LABEL`, then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
     * + If the `Scope` indicates `NAMESPACE`, then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.
     *
     * Labels are case sensitive and components of a label must be separated by colon, for example `NS1:NS2:name`.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Specify whether you want to match using the label name or just the namespace.
     */
    public val scope: aws.sdk.kotlin.services.wafv2.model.LabelMatchScope? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelMatchStatement(")
        append("key=$key,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelMatchStatement

        if (key != other.key) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:
         * + If the `Scope` indicates `LABEL`, then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
         * + If the `Scope` indicates `NAMESPACE`, then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.
         *
         * Labels are case sensitive and components of a label must be separated by colon, for example `NS1:NS2:name`.
         */
        public var key: kotlin.String? = null
        /**
         * Specify whether you want to match using the label name or just the namespace.
         */
        public var scope: aws.sdk.kotlin.services.wafv2.model.LabelMatchScope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement) : this() {
            this.key = x.key
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.LabelMatchStatement = LabelMatchStatement(this)
    }
}
