// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
 *
 * Use the `AWSManagedRulesBotControlRuleSet` configuration object to configure the protection level that you want the Bot Control rule group to use.
 *
 * For example specifications, see the examples section of CreateWebACL.
 */
public class ManagedRuleGroupConfig private constructor(builder: Builder) {
    /**
     * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see [WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) and [WAF Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html) in the *WAF Developer Guide*.
     */
    public val awsManagedRulesBotControlRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet? = builder.awsManagedRulesBotControlRuleSet
    /**
     * The path of the login endpoint for your application. For example, for the URL `https://example.com/web/login`, you would provide the path `/web/login`.
     */
    public val loginPath: kotlin.String? = builder.loginPath
    /**
     * Details about your login page password field.
     */
    public val passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = builder.passwordField
    /**
     * The payload type for your login endpoint, either JSON or form encoded.
     */
    public val payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = builder.payloadType
    /**
     * Details about your login page username field.
     */
    public val usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = builder.usernameField

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleGroupConfig(")
        append("awsManagedRulesBotControlRuleSet=$awsManagedRulesBotControlRuleSet,")
        append("loginPath=$loginPath,")
        append("passwordField=$passwordField,")
        append("payloadType=$payloadType,")
        append("usernameField=$usernameField")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsManagedRulesBotControlRuleSet?.hashCode() ?: 0
        result = 31 * result + (loginPath?.hashCode() ?: 0)
        result = 31 * result + (passwordField?.hashCode() ?: 0)
        result = 31 * result + (payloadType?.hashCode() ?: 0)
        result = 31 * result + (usernameField?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleGroupConfig

        if (awsManagedRulesBotControlRuleSet != other.awsManagedRulesBotControlRuleSet) return false
        if (loginPath != other.loginPath) return false
        if (passwordField != other.passwordField) return false
        if (payloadType != other.payloadType) return false
        if (usernameField != other.usernameField) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see [WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) and [WAF Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html) in the *WAF Developer Guide*.
         */
        public var awsManagedRulesBotControlRuleSet: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet? = null
        /**
         * The path of the login endpoint for your application. For example, for the URL `https://example.com/web/login`, you would provide the path `/web/login`.
         */
        public var loginPath: kotlin.String? = null
        /**
         * Details about your login page password field.
         */
        public var passwordField: aws.sdk.kotlin.services.wafv2.model.PasswordField? = null
        /**
         * The payload type for your login endpoint, either JSON or form encoded.
         */
        public var payloadType: aws.sdk.kotlin.services.wafv2.model.PayloadType? = null
        /**
         * Details about your login page username field.
         */
        public var usernameField: aws.sdk.kotlin.services.wafv2.model.UsernameField? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig) : this() {
            this.awsManagedRulesBotControlRuleSet = x.awsManagedRulesBotControlRuleSet
            this.loginPath = x.loginPath
            this.passwordField = x.passwordField
            this.payloadType = x.payloadType
            this.usernameField = x.usernameField
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupConfig = ManagedRuleGroupConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet] inside the given [block]
         */
        public fun awsManagedRulesBotControlRuleSet(block: aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet.Builder.() -> kotlin.Unit) {
            this.awsManagedRulesBotControlRuleSet = aws.sdk.kotlin.services.wafv2.model.AwsManagedRulesBotControlRuleSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.PasswordField] inside the given [block]
         */
        public fun passwordField(block: aws.sdk.kotlin.services.wafv2.model.PasswordField.Builder.() -> kotlin.Unit) {
            this.passwordField = aws.sdk.kotlin.services.wafv2.model.PasswordField.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UsernameField] inside the given [block]
         */
        public fun usernameField(block: aws.sdk.kotlin.services.wafv2.model.UsernameField.Builder.() -> kotlin.Unit) {
            this.usernameField = aws.sdk.kotlin.services.wafv2.model.UsernameField.invoke(block)
        }
    }
}
