// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * High-level information for a managed rule set.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 */
public class ManagedRuleSetSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A description of the set that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the managed rule set. The ID is returned in the responses to commands like `list`. You provide it to operations like `get` and `update`.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix.
     * + The syntax for the label namespace prefix for a managed rule group is the following: `awswaf:managed:<vendor>:<rule group name>`:
     * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
     */
    public val labelNamespace: kotlin.String? = builder.labelNamespace
    /**
     * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
     */
    public val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
     *
     * This name is assigned to the corresponding managed rule group, which your customers can access and use.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleSetSummary(")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("labelNamespace=$labelNamespace,")
        append("lockToken=$lockToken,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (labelNamespace?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedRuleSetSummary

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (labelNamespace != other.labelNamespace) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleSetSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        public var arn: kotlin.String? = null
        /**
         * A description of the set that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the managed rule set. The ID is returned in the responses to commands like `list`. You provide it to operations like `get` and `update`.
         */
        public var id: kotlin.String? = null
        /**
         * The label namespace prefix for the managed rule groups that are offered to customers from this managed rule set. All labels that are added by rules in the managed rule group have this prefix.
         * + The syntax for the label namespace prefix for a managed rule group is the following: `awswaf:managed:<vendor>:<rule group name>`:
         * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
         */
        public var labelNamespace: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your `get` and `list` requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like `update` and `delete`. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a `WAFOptimisticLockException`. If this happens, perform another `get`, and use the new token returned by that operation.
         */
        public var lockToken: kotlin.String? = null
        /**
         * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
         *
         * This name is assigned to the corresponding managed rule group, which your customers can access and use.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleSetSummary) : this() {
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.labelNamespace = x.labelNamespace
            this.lockToken = x.lockToken
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleSetSummary = ManagedRuleSetSummary(this)
    }
}
