// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The action that WAF should take on a web request when it matches a rule's statement. Settings at the web ACL level can override the rule action setting.
 */
public class RuleAction private constructor(builder: Builder) {
    /**
     * Instructs WAF to allow the web request.
     */
    public val allow: aws.sdk.kotlin.services.wafv2.model.AllowAction? = builder.allow
    /**
     * Instructs WAF to block the web request.
     */
    public val block: aws.sdk.kotlin.services.wafv2.model.BlockAction? = builder.block
    /**
     * Instructs WAF to run a `CAPTCHA` check against the web request.
     */
    public val captcha: aws.sdk.kotlin.services.wafv2.model.CaptchaAction? = builder.captcha
    /**
     * Instructs WAF to run a `Challenge` check against the web request.
     */
    public val challenge: aws.sdk.kotlin.services.wafv2.model.ChallengeAction? = builder.challenge
    /**
     * Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.
     */
    public val count: aws.sdk.kotlin.services.wafv2.model.CountAction? = builder.count

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RuleAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleAction(")
        append("allow=$allow,")
        append("block=$block,")
        append("captcha=$captcha,")
        append("challenge=$challenge,")
        append("count=$count")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allow?.hashCode() ?: 0
        result = 31 * result + (block?.hashCode() ?: 0)
        result = 31 * result + (captcha?.hashCode() ?: 0)
        result = 31 * result + (challenge?.hashCode() ?: 0)
        result = 31 * result + (count?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleAction

        if (allow != other.allow) return false
        if (block != other.block) return false
        if (captcha != other.captcha) return false
        if (challenge != other.challenge) return false
        if (count != other.count) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RuleAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Instructs WAF to allow the web request.
         */
        public var allow: aws.sdk.kotlin.services.wafv2.model.AllowAction? = null
        /**
         * Instructs WAF to block the web request.
         */
        public var block: aws.sdk.kotlin.services.wafv2.model.BlockAction? = null
        /**
         * Instructs WAF to run a `CAPTCHA` check against the web request.
         */
        public var captcha: aws.sdk.kotlin.services.wafv2.model.CaptchaAction? = null
        /**
         * Instructs WAF to run a `Challenge` check against the web request.
         */
        public var challenge: aws.sdk.kotlin.services.wafv2.model.ChallengeAction? = null
        /**
         * Instructs WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.
         */
        public var count: aws.sdk.kotlin.services.wafv2.model.CountAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RuleAction) : this() {
            this.allow = x.allow
            this.block = x.block
            this.captcha = x.captcha
            this.challenge = x.challenge
            this.count = x.count
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RuleAction = RuleAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AllowAction] inside the given [block]
         */
        public fun allow(block: aws.sdk.kotlin.services.wafv2.model.AllowAction.Builder.() -> kotlin.Unit) {
            this.allow = aws.sdk.kotlin.services.wafv2.model.AllowAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.BlockAction] inside the given [block]
         */
        public fun block(block: aws.sdk.kotlin.services.wafv2.model.BlockAction.Builder.() -> kotlin.Unit) {
            this.block = aws.sdk.kotlin.services.wafv2.model.BlockAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CaptchaAction] inside the given [block]
         */
        public fun captcha(block: aws.sdk.kotlin.services.wafv2.model.CaptchaAction.Builder.() -> kotlin.Unit) {
            this.captcha = aws.sdk.kotlin.services.wafv2.model.CaptchaAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ChallengeAction] inside the given [block]
         */
        public fun challenge(block: aws.sdk.kotlin.services.wafv2.model.ChallengeAction.Builder.() -> kotlin.Unit) {
            this.challenge = aws.sdk.kotlin.services.wafv2.model.ChallengeAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CountAction] inside the given [block]
         */
        public fun count(block: aws.sdk.kotlin.services.wafv2.model.CountAction.Builder.() -> kotlin.Unit) {
            this.count = aws.sdk.kotlin.services.wafv2.model.CountAction.invoke(block)
        }
    }
}
