// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
 */
public class RuleGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the `RuleLabels` for a Rule.
     */
    public val availableLabels: List<LabelSummary>? = builder.availableLabels
    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     *
     * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using CheckCapacity.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    public val capacity: kotlin.Long = builder.capacity
    /**
     * The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a `LabelMatchStatement` specification, in the Statement definition of a rule.
     */
    public val consumedLabels: List<LabelSummary>? = builder.consumedLabels
    /**
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    public val customResponseBodies: Map<String, CustomResponseBody>? = builder.customResponseBodies
    /**
     * A description of the rule group that helps with identification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix.
     * + The syntax for the label namespace prefix for your rule groups is the following: `awswaf:<account ID>:rulegroup:<rule group name>:`
     * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
     */
    public val labelNamespace: kotlin.String? = builder.labelNamespace
    /**
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    public val rules: List<Rule>? = builder.rules
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RuleGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroup(")
        append("arn=$arn,")
        append("availableLabels=$availableLabels,")
        append("capacity=$capacity,")
        append("consumedLabels=$consumedLabels,")
        append("customResponseBodies=$customResponseBodies,")
        append("description=$description,")
        append("id=$id,")
        append("labelNamespace=$labelNamespace,")
        append("name=$name,")
        append("rules=$rules,")
        append("visibilityConfig=$visibilityConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (availableLabels?.hashCode() ?: 0)
        result = 31 * result + (capacity.hashCode())
        result = 31 * result + (consumedLabels?.hashCode() ?: 0)
        result = 31 * result + (customResponseBodies?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (labelNamespace?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroup

        if (arn != other.arn) return false
        if (availableLabels != other.availableLabels) return false
        if (capacity != other.capacity) return false
        if (consumedLabels != other.consumedLabels) return false
        if (customResponseBodies != other.customResponseBodies) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (labelNamespace != other.labelNamespace) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RuleGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        public var arn: kotlin.String? = null
        /**
         * The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the `RuleLabels` for a Rule.
         */
        public var availableLabels: List<LabelSummary>? = null
        /**
         * The web ACL capacity units (WCUs) required for this rule group.
         *
         * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using CheckCapacity.
         *
         * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
         */
        public var capacity: kotlin.Long = 0L
        /**
         * The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a `LabelMatchStatement` specification, in the Statement definition of a rule.
         */
        public var consumedLabels: List<LabelSummary>? = null
        /**
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        public var customResponseBodies: Map<String, CustomResponseBody>? = null
        /**
         * A description of the rule group that helps with identification.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var id: kotlin.String? = null
        /**
         * The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix.
         * + The syntax for the label namespace prefix for your rule groups is the following: `awswaf:<account ID>:rulegroup:<rule group name>:`
         * + When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: `<label namespace>:<label from rule>`
         */
        public var labelNamespace: kotlin.String? = null
        /**
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        public var rules: List<Rule>? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        public var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RuleGroup) : this() {
            this.arn = x.arn
            this.availableLabels = x.availableLabels
            this.capacity = x.capacity
            this.consumedLabels = x.consumedLabels
            this.customResponseBodies = x.customResponseBodies
            this.description = x.description
            this.id = x.id
            this.labelNamespace = x.labelNamespace
            this.name = x.name
            this.rules = x.rules
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RuleGroup = RuleGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        public fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }
    }
}
