// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a single sampled web request. The response from GetSampledRequests includes a `SampledHTTPRequests` complex type that appears as `SampledRequests` in the response syntax. `SampledHTTPRequests` contains an array of `SampledHTTPRequest` objects.
 */
public class SampledHttpRequest private constructor(builder: Builder) {
    /**
     * The action that WAF applied to the request.
     */
    public val action: kotlin.String? = builder.action
    /**
     * The `CAPTCHA` response for the request.
     */
    public val captchaResponse: aws.sdk.kotlin.services.wafv2.model.CaptchaResponse? = builder.captchaResponse
    /**
     * The `Challenge` response for the request.
     */
    public val challengeResponse: aws.sdk.kotlin.services.wafv2.model.ChallengeResponse? = builder.challengeResponse
    /**
     * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
     *
     * For example, `awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA` or `awswaf:managed:aws:managed-rule-set:header:encoding:utf8`.
     */
    public val labels: List<Label>? = builder.labels
    /**
     * Used only for rule group rules that have a rule action override in place in the web ACL. This is the action that the rule group rule is configured for, and not the action that was applied to the request. The action that WAF applied is the `Action` value.
     */
    public val overriddenAction: kotlin.String? = builder.overriddenAction
    /**
     * A complex type that contains detailed information about the request.
     */
    public val request: aws.sdk.kotlin.services.wafv2.model.HttpRequest? = builder.request
    /**
     * Custom request headers inserted by WAF into the request, according to the custom request configuration for the matching rule action.
     */
    public val requestHeadersInserted: List<HttpHeader>? = builder.requestHeadersInserted
    /**
     * The response code that was sent for the request.
     */
    public val responseCodeSent: kotlin.Int? = builder.responseCodeSent
    /**
     * The name of the `Rule` that the request matched. For managed rule groups, the format for this name is `<vendor name>#<managed rule group name>#<rule name>`. For your own rule groups, the format for this name is `<rule group name>#<rule name>`. If the rule is not in a rule group, this field is absent.
     */
    public val ruleNameWithinRuleGroup: kotlin.String? = builder.ruleNameWithinRuleGroup
    /**
     * The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in seconds).
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * A value that indicates how one result in the response relates proportionally to other results in the response. For example, a result that has a weight of `2` represents roughly twice as many web requests as a result that has a weight of `1`.
     */
    public val weight: kotlin.Long = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SampledHttpRequest(")
        append("action=$action,")
        append("captchaResponse=$captchaResponse,")
        append("challengeResponse=$challengeResponse,")
        append("labels=$labels,")
        append("overriddenAction=$overriddenAction,")
        append("request=$request,")
        append("requestHeadersInserted=$requestHeadersInserted,")
        append("responseCodeSent=$responseCodeSent,")
        append("ruleNameWithinRuleGroup=$ruleNameWithinRuleGroup,")
        append("timestamp=$timestamp,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (captchaResponse?.hashCode() ?: 0)
        result = 31 * result + (challengeResponse?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (overriddenAction?.hashCode() ?: 0)
        result = 31 * result + (request?.hashCode() ?: 0)
        result = 31 * result + (requestHeadersInserted?.hashCode() ?: 0)
        result = 31 * result + (responseCodeSent ?: 0)
        result = 31 * result + (ruleNameWithinRuleGroup?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (weight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SampledHttpRequest

        if (action != other.action) return false
        if (captchaResponse != other.captchaResponse) return false
        if (challengeResponse != other.challengeResponse) return false
        if (labels != other.labels) return false
        if (overriddenAction != other.overriddenAction) return false
        if (request != other.request) return false
        if (requestHeadersInserted != other.requestHeadersInserted) return false
        if (responseCodeSent != other.responseCodeSent) return false
        if (ruleNameWithinRuleGroup != other.ruleNameWithinRuleGroup) return false
        if (timestamp != other.timestamp) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action that WAF applied to the request.
         */
        public var action: kotlin.String? = null
        /**
         * The `CAPTCHA` response for the request.
         */
        public var captchaResponse: aws.sdk.kotlin.services.wafv2.model.CaptchaResponse? = null
        /**
         * The `Challenge` response for the request.
         */
        public var challengeResponse: aws.sdk.kotlin.services.wafv2.model.ChallengeResponse? = null
        /**
         * Labels applied to the web request by matching rules. WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
         *
         * For example, `awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA` or `awswaf:managed:aws:managed-rule-set:header:encoding:utf8`.
         */
        public var labels: List<Label>? = null
        /**
         * Used only for rule group rules that have a rule action override in place in the web ACL. This is the action that the rule group rule is configured for, and not the action that was applied to the request. The action that WAF applied is the `Action` value.
         */
        public var overriddenAction: kotlin.String? = null
        /**
         * A complex type that contains detailed information about the request.
         */
        public var request: aws.sdk.kotlin.services.wafv2.model.HttpRequest? = null
        /**
         * Custom request headers inserted by WAF into the request, according to the custom request configuration for the matching rule action.
         */
        public var requestHeadersInserted: List<HttpHeader>? = null
        /**
         * The response code that was sent for the request.
         */
        public var responseCodeSent: kotlin.Int? = null
        /**
         * The name of the `Rule` that the request matched. For managed rule groups, the format for this name is `<vendor name>#<managed rule group name>#<rule name>`. For your own rule groups, the format for this name is `<rule group name>#<rule name>`. If the rule is not in a rule group, this field is absent.
         */
        public var ruleNameWithinRuleGroup: kotlin.String? = null
        /**
         * The time at which WAF received the request from your Amazon Web Services resource, in Unix time format (in seconds).
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value that indicates how one result in the response relates proportionally to other results in the response. For example, a result that has a weight of `2` represents roughly twice as many web requests as a result that has a weight of `1`.
         */
        public var weight: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest) : this() {
            this.action = x.action
            this.captchaResponse = x.captchaResponse
            this.challengeResponse = x.challengeResponse
            this.labels = x.labels
            this.overriddenAction = x.overriddenAction
            this.request = x.request
            this.requestHeadersInserted = x.requestHeadersInserted
            this.responseCodeSent = x.responseCodeSent
            this.ruleNameWithinRuleGroup = x.ruleNameWithinRuleGroup
            this.timestamp = x.timestamp
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest = SampledHttpRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CaptchaResponse] inside the given [block]
         */
        public fun captchaResponse(block: aws.sdk.kotlin.services.wafv2.model.CaptchaResponse.Builder.() -> kotlin.Unit) {
            this.captchaResponse = aws.sdk.kotlin.services.wafv2.model.CaptchaResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ChallengeResponse] inside the given [block]
         */
        public fun challengeResponse(block: aws.sdk.kotlin.services.wafv2.model.ChallengeResponse.Builder.() -> kotlin.Unit) {
            this.challengeResponse = aws.sdk.kotlin.services.wafv2.model.ChallengeResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.HttpRequest] inside the given [block]
         */
        public fun request(block: aws.sdk.kotlin.services.wafv2.model.HttpRequest.Builder.() -> kotlin.Unit) {
            this.request = aws.sdk.kotlin.services.wafv2.model.HttpRequest.invoke(block)
        }
    }
}
