// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
 */
public class SqliMatchStatement private constructor(builder: Builder) {
    /**
     * The part of the web request that you want WAF to inspect.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * The sensitivity that you want WAF to use to inspect for SQL injection attacks.
     *
     * `HIGH` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see [Testing and tuning](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html) in the *WAF Developer Guide*.
     *
     * `LOW` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.
     *
     * Default: `LOW`
     */
    public val sensitivityLevel: aws.sdk.kotlin.services.wafv2.model.SensitivityLevel? = builder.sensitivityLevel
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
     */
    public val textTransformations: List<TextTransformation>? = builder.textTransformations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqliMatchStatement(")
        append("fieldToMatch=$fieldToMatch,")
        append("sensitivityLevel=$sensitivityLevel,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldToMatch?.hashCode() ?: 0
        result = 31 * result + (sensitivityLevel?.hashCode() ?: 0)
        result = 31 * result + (textTransformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqliMatchStatement

        if (fieldToMatch != other.fieldToMatch) return false
        if (sensitivityLevel != other.sensitivityLevel) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The part of the web request that you want WAF to inspect.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * The sensitivity that you want WAF to use to inspect for SQL injection attacks.
         *
         * `HIGH` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see [Testing and tuning](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html) in the *WAF Developer Guide*.
         *
         * `LOW` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.
         *
         * Default: `LOW`
         */
        public var sensitivityLevel: aws.sdk.kotlin.services.wafv2.model.SensitivityLevel? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement) : this() {
            this.fieldToMatch = x.fieldToMatch
            this.sensitivityLevel = x.sensitivityLevel
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.SqliMatchStatement = SqliMatchStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }
    }
}
