// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A version of the named managed rule group, that the rule group's vendor publishes for use by customers.
 *
 * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
 *
 * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
 */
public class VersionToPublish private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the vendor's rule group that's used in the published managed rule group version.
     */
    public val associatedRuleGroupArn: kotlin.String? = builder.associatedRuleGroupArn
    /**
     * The amount of time the vendor expects this version of the managed rule group to last, in days.
     */
    public val forecastedLifetime: kotlin.Int? = builder.forecastedLifetime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.VersionToPublish = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VersionToPublish(")
        append("associatedRuleGroupArn=$associatedRuleGroupArn,")
        append("forecastedLifetime=$forecastedLifetime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedRuleGroupArn?.hashCode() ?: 0
        result = 31 * result + (forecastedLifetime ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VersionToPublish

        if (associatedRuleGroupArn != other.associatedRuleGroupArn) return false
        if (forecastedLifetime != other.forecastedLifetime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.VersionToPublish = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the vendor's rule group that's used in the published managed rule group version.
         */
        public var associatedRuleGroupArn: kotlin.String? = null
        /**
         * The amount of time the vendor expects this version of the managed rule group to last, in days.
         */
        public var forecastedLifetime: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.VersionToPublish) : this() {
            this.associatedRuleGroupArn = x.associatedRuleGroupArn
            this.forecastedLifetime = x.forecastedLifetime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.VersionToPublish = VersionToPublish(this)
    }
}
