// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The operation failed because WAF didn't recognize a parameter in the request. For example:
 * + You specified a parameter name or value that isn't valid.
 * + Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested.
 * + You tried to update a `WebACL` with a `DefaultAction` that isn't among the types available at DefaultAction.
 * + Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.
 */
public class WafInvalidParameterException private constructor(builder: Builder) : Wafv2Exception() {

    /**
     * The settings where the invalid parameter was found.
     */
    public val field: aws.sdk.kotlin.services.wafv2.model.ParameterExceptionField? = builder.field
    override val message: kotlin.String? = builder.message
    /**
     * The invalid parameter that resulted in the exception.
     */
    public val parameter: kotlin.String? = builder.parameter
    /**
     * Additional information about the exception.
     */
    public val reason: kotlin.String? = builder.reason

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.WafInvalidParameterException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WafInvalidParameterException(")
        append("field=$field,")
        append("message=$message,")
        append("parameter=$parameter,")
        append("reason=$reason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (parameter?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WafInvalidParameterException

        if (field != other.field) return false
        if (message != other.message) return false
        if (parameter != other.parameter) return false
        if (reason != other.reason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.WafInvalidParameterException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The settings where the invalid parameter was found.
         */
        public var field: aws.sdk.kotlin.services.wafv2.model.ParameterExceptionField? = null
        public var message: kotlin.String? = null
        /**
         * The invalid parameter that resulted in the exception.
         */
        public var parameter: kotlin.String? = null
        /**
         * Additional information about the exception.
         */
        public var reason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.WafInvalidParameterException) : this() {
            this.field = x.field
            this.message = x.message
            this.parameter = x.parameter
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.WafInvalidParameterException = WafInvalidParameterException(this)
    }
}
