// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
 */
public class XssMatchStatement private constructor(builder: Builder) {
    /**
     * The part of the web request that you want WAF to inspect.
     */
    public val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
     */
    public val textTransformations: List<TextTransformation>? = builder.textTransformations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.XssMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XssMatchStatement(")
        append("fieldToMatch=$fieldToMatch,")
        append("textTransformations=$textTransformations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldToMatch?.hashCode() ?: 0
        result = 31 * result + (textTransformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XssMatchStatement

        if (fieldToMatch != other.fieldToMatch) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.XssMatchStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The part of the web request that you want WAF to inspect.
         */
        public var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
         */
        public var textTransformations: List<TextTransformation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.XssMatchStatement) : this() {
            this.fieldToMatch = x.fieldToMatch
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.XssMatchStatement = XssMatchStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        public fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }
    }
}
