// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse
import aws.sdk.kotlin.services.wafv2.model.SampledHttpRequest
import aws.sdk.kotlin.services.wafv2.model.TimeWindow
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSampledRequestsOperationDeserializer: HttpDeserialize<GetSampledRequestsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSampledRequestsResponse {
        if (!response.status.isSuccess()) {
            throwGetSampledRequestsError(context, response)
        }
        val builder = GetSampledRequestsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSampledRequestsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSampledRequestsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSampledRequestsOperationBody(builder: GetSampledRequestsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val POPULATIONSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("PopulationSize"))
    val SAMPLEDREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SampledRequests"))
    val TIMEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeWindow"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(POPULATIONSIZE_DESCRIPTOR)
        field(SAMPLEDREQUESTS_DESCRIPTOR)
        field(TIMEWINDOW_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                POPULATIONSIZE_DESCRIPTOR.index -> builder.populationSize = deserializeLong()
                SAMPLEDREQUESTS_DESCRIPTOR.index -> builder.sampledRequests =
                    deserializer.deserializeList(SAMPLEDREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SampledHttpRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSampledHttpRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TIMEWINDOW_DESCRIPTOR.index -> builder.timeWindow = deserializeTimeWindowDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
