// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.wafv2.model.ListMobileSdkReleasesResponse
import aws.sdk.kotlin.services.wafv2.model.ReleaseSummary
import aws.sdk.kotlin.services.wafv2.model.Wafv2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListMobileSdkReleasesOperationDeserializer: HttpDeserialize<ListMobileSdkReleasesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListMobileSdkReleasesResponse {
        if (!response.status.isSuccess()) {
            throwListMobileSdkReleasesError(context, response)
        }
        val builder = ListMobileSdkReleasesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListMobileSdkReleasesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListMobileSdkReleasesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Wafv2Exception("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidOperationException" -> WafInvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Wafv2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListMobileSdkReleasesOperationBody(builder: ListMobileSdkReleasesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextMarker"))
    val RELEASESUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReleaseSummaries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTMARKER_DESCRIPTOR)
        field(RELEASESUMMARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                RELEASESUMMARIES_DESCRIPTOR.index -> builder.releaseSummaries =
                    deserializer.deserializeList(RELEASESUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ReleaseSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReleaseSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
