// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.endpoints

import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region ap-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "eu-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "eu-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "eu-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "eu-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-gov-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "me-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.me-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "me-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.me-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "me-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.me-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "me-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.me-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ca-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ca-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ca-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ca-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ca-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ca-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ca-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack enabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "eu-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS enabled and DualStack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "eu-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack enabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "eu-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-central-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "eu-central-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-central-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "us-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "us-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "af-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "af-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test34() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "af-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.af-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region af-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test35() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "af-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.af-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test36() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "eu-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test37() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "eu-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test38() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "eu-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-north-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test39() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "eu-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-north-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS enabled and DualStack enabled
    @Test
    fun test40() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "eu-west-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-west-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS enabled and DualStack disabled
    @Test
    fun test41() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "eu-west-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-west-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS disabled and DualStack enabled
    @Test
    fun test42() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "eu-west-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-west-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-3 with FIPS disabled and DualStack disabled
    @Test
    fun test43() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "eu-west-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-west-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack enabled
    @Test
    fun test44() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "eu-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS enabled and DualStack disabled
    @Test
    fun test45() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "eu-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack enabled
    @Test
    fun test46() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "eu-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-west-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test47() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "eu-west-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-west-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test48() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "eu-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test49() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "eu-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test50() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "eu-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test51() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "eu-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.eu-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS enabled and DualStack enabled
    @Test
    fun test52() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-northeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-northeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS enabled and DualStack disabled
    @Test
    fun test53() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-northeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-northeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS disabled and DualStack enabled
    @Test
    fun test54() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-northeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-northeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-3 with FIPS disabled and DualStack disabled
    @Test
    fun test55() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-northeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-northeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test56() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-northeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test57() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-northeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test58() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-northeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-northeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test59() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-northeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-northeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test60() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-northeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test61() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-northeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test62() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-northeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-northeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test63() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-northeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-northeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS enabled and DualStack enabled
    @Test
    fun test64() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "me-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.me-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS enabled and DualStack disabled
    @Test
    fun test65() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "me-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.me-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS disabled and DualStack enabled
    @Test
    fun test66() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "me-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.me-south-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region me-south-1 with FIPS disabled and DualStack disabled
    @Test
    fun test67() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "me-south-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.me-south-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test68() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "sa-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.sa-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test69() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "sa-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.sa-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test70() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "sa-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.sa-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region sa-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test71() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "sa-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.sa-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test72() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test73() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test74() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test75() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test76() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test77() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test78() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test79() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "cn-north-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS enabled and DualStack enabled
    @Test
    fun test80() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "us-gov-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-gov-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS enabled and DualStack disabled
    @Test
    fun test81() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-gov-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-gov-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS disabled and DualStack enabled
    @Test
    fun test82() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-gov-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-gov-west-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test83() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-gov-west-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-gov-west-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack enabled
    @Test
    fun test84() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-southeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS enabled and DualStack disabled
    @Test
    fun test85() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-southeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack enabled
    @Test
    fun test86() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-southeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-southeast-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test87() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-southeast-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-southeast-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack enabled
    @Test
    fun test88() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-southeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS enabled and DualStack disabled
    @Test
    fun test89() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-southeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack enabled
    @Test
    fun test90() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-southeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-southeast-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test91() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-southeast-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-southeast-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS enabled and DualStack enabled
    @Test
    fun test92() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "ap-southeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-southeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS enabled and DualStack disabled
    @Test
    fun test93() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "ap-southeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.ap-southeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS disabled and DualStack enabled
    @Test
    fun test94() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "ap-southeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-southeast-3.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-3 with FIPS disabled and DualStack disabled
    @Test
    fun test95() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "ap-southeast-3"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.ap-southeast-3.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test96() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test97() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test98() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test99() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-east-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack enabled
    @Test
    fun test100() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "us-east-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS enabled and DualStack disabled
    @Test
    fun test101() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-east-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack enabled
    @Test
    fun test102() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-east-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-east-2.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack disabled
    @Test
    fun test103() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-east-2"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.us-east-2.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS enabled and DualStack enabled
    @Test
    fun test104() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = true
            region = "cn-northwest-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.cn-northwest-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS enabled and DualStack disabled
    @Test
    fun test105() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "cn-northwest-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2-fips.cn-northwest-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS disabled and DualStack enabled
    @Test
    fun test106() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "cn-northwest-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.cn-northwest-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-northwest-1 with FIPS disabled and DualStack disabled
    @Test
    fun test107() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "cn-northwest-1"
        }
        val expected = Endpoint(
            uri = Url.parse("https://wafv2.cn-northwest-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips disabled and dualstack disabled
    @Test
    fun test108() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            region = "us-east-1"
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test109() = runTest {
        val params = EndpointParameters {
            useFips = true
            useDualStack = false
            region = "us-east-1"
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test110() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = true
            region = "us-east-1"
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
