// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Specifies that WAF should allow the request and optionally defines additional
 * custom handling for the request.
 * This is used in the context of other settings, for example to specify values for RuleAction and web ACL DefaultAction.
 */
class AllowAction private constructor(builder: Builder) {
    /**
     * Defines custom handling for the web request.
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF in the
     * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
     */
    val customRequestHandling: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling? = builder.customRequestHandling

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.AllowAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AllowAction(")
        append("customRequestHandling=$customRequestHandling)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customRequestHandling?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AllowAction

        if (customRequestHandling != other.customRequestHandling) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.AllowAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Defines custom handling for the web request.
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF in the
         * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
         */
        var customRequestHandling: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.AllowAction) : this() {
            this.customRequestHandling = x.customRequestHandling
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.AllowAction = AllowAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling] inside the given [block]
         */
        fun customRequestHandling(block: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling.Builder.() -> kotlin.Unit) {
            this.customRequestHandling = aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling.invoke(block)
        }
    }
}
