// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class CreateIpSetRequest private constructor(builder: Builder) {
    /**
     * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
     * Examples:
     * To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32.
     * To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
     * 192.0.2.0/24.
     * To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
     * To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
     * For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing.
     */
    val addresses: List<String>? = builder.addresses
    /**
     * A description of the IP set that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * The version of the IP addresses, either IPV4 or IPV6.
     */
    val ipAddressVersion: aws.sdk.kotlin.services.wafv2.model.IpAddressVersion? = builder.ipAddressVersion
    /**
     * The name of the IP set. You cannot change the name of an IPSet after you create it.
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * An array of key:value pairs to associate with the resource.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CreateIpSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIpSetRequest(")
        append("addresses=$addresses,")
        append("description=$description,")
        append("ipAddressVersion=$ipAddressVersion,")
        append("name=$name,")
        append("scope=$scope,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addresses?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ipAddressVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateIpSetRequest

        if (addresses != other.addresses) return false
        if (description != other.description) return false
        if (ipAddressVersion != other.ipAddressVersion) return false
        if (name != other.name) return false
        if (scope != other.scope) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CreateIpSetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
         * Examples:
         * To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32.
         * To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
         * 192.0.2.0/24.
         * To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
         * To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
         * For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing.
         */
        var addresses: List<String>? = null
        /**
         * A description of the IP set that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * The version of the IP addresses, either IPV4 or IPV6.
         */
        var ipAddressVersion: aws.sdk.kotlin.services.wafv2.model.IpAddressVersion? = null
        /**
         * The name of the IP set. You cannot change the name of an IPSet after you create it.
         */
        var name: kotlin.String? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * An array of key:value pairs to associate with the resource.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CreateIpSetRequest) : this() {
            this.addresses = x.addresses
            this.description = x.description
            this.ipAddressVersion = x.ipAddressVersion
            this.name = x.name
            this.scope = x.scope
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CreateIpSetRequest = CreateIpSetRequest(this)
    }
}
