// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Custom request handling behavior that inserts custom headers into a web request. You can
 * add custom request handling for the rule actions allow and count.
 * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF in the
 * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
 */
class CustomRequestHandling private constructor(builder: Builder) {
    /**
     * The HTTP headers to insert into the request. Duplicate header names are not allowed.
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas in the
     * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
     */
    val insertHeaders: List<CustomHttpHeader>? = builder.insertHeaders

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomRequestHandling(")
        append("insertHeaders=$insertHeaders)")
    }

    override fun hashCode(): kotlin.Int {
        var result = insertHeaders?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomRequestHandling

        if (insertHeaders != other.insertHeaders) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling = Builder(this).apply(block).build()

    class Builder {
        /**
         * The HTTP headers to insert into the request. Duplicate header names are not allowed.
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas in the
         * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide.
         */
        var insertHeaders: List<CustomHttpHeader>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling) : this() {
            this.insertHeaders = x.insertHeaders
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CustomRequestHandling = CustomRequestHandling(this)
    }
}
