// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The part of a web request that you want WAF to inspect. Include the single FieldToMatch type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in FieldToMatch for each rule statement that requires it. To inspect more than one component of a web request, create a separate rule statement for each component.
 * JSON specification for a QueryString field to match:
 * "FieldToMatch": { "QueryString": {} }
 * Example JSON for a Method field to match specification:
 * "FieldToMatch": { "Method": { "Name": "DELETE" } }
 */
class FieldToMatch private constructor(builder: Builder) {
    /**
     * Inspect all query arguments.
     */
    val allQueryArguments: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments? = builder.allQueryArguments
    /**
     * Inspect the request body as plain text. The request body immediately follows the request
     * headers. This is the part of a request that contains any additional data that you want to
     * send to your web server as the HTTP request body, such as data from a form.
     * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to
     * WAF for inspection by the underlying host service. If you don't need to inspect more
     * than 8 KB, you can guarantee that you don't allow additional bytes in by combining a
     * statement that inspects the body of the web request, such as ByteMatchStatement or RegexPatternSetReferenceStatement,
     * with a SizeConstraintStatement that enforces an 8 KB size limit on the
     * body of the request. WAF doesn't support inspecting the entire contents of web requests
     * whose bodies exceed the 8 KB limit.
     */
    val body: aws.sdk.kotlin.services.wafv2.model.Body? = builder.body
    /**
     * Inspect the request body as JSON. The request body immediately follows the request
     * headers. This is the part of a request that contains any additional data that you want to
     * send to your web server as the HTTP request body, such as data from a form.
     * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to
     * WAF for inspection by the underlying host service. If you don't need to inspect more
     * than 8 KB, you can guarantee that you don't allow additional bytes in by combining a
     * statement that inspects the body of the web request, such as ByteMatchStatement or RegexPatternSetReferenceStatement,
     * with a SizeConstraintStatement that enforces an 8 KB size limit on the
     * body of the request. WAF doesn't support inspecting the entire contents of web requests
     * whose bodies exceed the 8 KB limit.
     */
    val jsonBody: aws.sdk.kotlin.services.wafv2.model.JsonBody? = builder.jsonBody
    /**
     * Inspect the HTTP method. The method indicates the type of operation that the request is
     * asking the origin to perform.
     */
    val method: aws.sdk.kotlin.services.wafv2.model.Method? = builder.method
    /**
     * Inspect the query string. This is the part of a URL that appears after a ?
     * character, if any.
     */
    val queryString: aws.sdk.kotlin.services.wafv2.model.QueryString? = builder.queryString
    /**
     * Inspect a single header. Provide the name of the header to inspect, for example,
     * User-Agent or Referer. This setting isn't case
     * sensitive.
     * Example JSON: "SingleHeader": { "Name": "haystack" }
     */
    val singleHeader: aws.sdk.kotlin.services.wafv2.model.SingleHeader? = builder.singleHeader
    /**
     * Inspect a single query argument. Provide the name of the query argument to inspect, such
     * as UserName or SalesRegion. The name can be up to
     * 30 characters long and isn't case sensitive.
     * This is used only to indicate the web request component for WAF to inspect, in the FieldToMatch specification.
     * Example JSON: "SingleQueryArgument": { "Name": "myArgument" }
     */
    val singleQueryArgument: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument? = builder.singleQueryArgument
    /**
     * Inspect the request URI path. This is the part of a web request that identifies a
     * resource, for example, /images/daily-ad.jpg.
     */
    val uriPath: aws.sdk.kotlin.services.wafv2.model.UriPath? = builder.uriPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FieldToMatch(")
        append("allQueryArguments=$allQueryArguments,")
        append("body=$body,")
        append("jsonBody=$jsonBody,")
        append("method=$method,")
        append("queryString=$queryString,")
        append("singleHeader=$singleHeader,")
        append("singleQueryArgument=$singleQueryArgument,")
        append("uriPath=$uriPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allQueryArguments?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (jsonBody?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (singleHeader?.hashCode() ?: 0)
        result = 31 * result + (singleQueryArgument?.hashCode() ?: 0)
        result = 31 * result + (uriPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FieldToMatch

        if (allQueryArguments != other.allQueryArguments) return false
        if (body != other.body) return false
        if (jsonBody != other.jsonBody) return false
        if (method != other.method) return false
        if (queryString != other.queryString) return false
        if (singleHeader != other.singleHeader) return false
        if (singleQueryArgument != other.singleQueryArgument) return false
        if (uriPath != other.uriPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = Builder(this).apply(block).build()

    class Builder {
        /**
         * Inspect all query arguments.
         */
        var allQueryArguments: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments? = null
        /**
         * Inspect the request body as plain text. The request body immediately follows the request
         * headers. This is the part of a request that contains any additional data that you want to
         * send to your web server as the HTTP request body, such as data from a form.
         * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to
         * WAF for inspection by the underlying host service. If you don't need to inspect more
         * than 8 KB, you can guarantee that you don't allow additional bytes in by combining a
         * statement that inspects the body of the web request, such as ByteMatchStatement or RegexPatternSetReferenceStatement,
         * with a SizeConstraintStatement that enforces an 8 KB size limit on the
         * body of the request. WAF doesn't support inspecting the entire contents of web requests
         * whose bodies exceed the 8 KB limit.
         */
        var body: aws.sdk.kotlin.services.wafv2.model.Body? = null
        /**
         * Inspect the request body as JSON. The request body immediately follows the request
         * headers. This is the part of a request that contains any additional data that you want to
         * send to your web server as the HTTP request body, such as data from a form.
         * Note that only the first 8 KB (8192 bytes) of the request body are forwarded to
         * WAF for inspection by the underlying host service. If you don't need to inspect more
         * than 8 KB, you can guarantee that you don't allow additional bytes in by combining a
         * statement that inspects the body of the web request, such as ByteMatchStatement or RegexPatternSetReferenceStatement,
         * with a SizeConstraintStatement that enforces an 8 KB size limit on the
         * body of the request. WAF doesn't support inspecting the entire contents of web requests
         * whose bodies exceed the 8 KB limit.
         */
        var jsonBody: aws.sdk.kotlin.services.wafv2.model.JsonBody? = null
        /**
         * Inspect the HTTP method. The method indicates the type of operation that the request is
         * asking the origin to perform.
         */
        var method: aws.sdk.kotlin.services.wafv2.model.Method? = null
        /**
         * Inspect the query string. This is the part of a URL that appears after a ?
         * character, if any.
         */
        var queryString: aws.sdk.kotlin.services.wafv2.model.QueryString? = null
        /**
         * Inspect a single header. Provide the name of the header to inspect, for example,
         * User-Agent or Referer. This setting isn't case
         * sensitive.
         * Example JSON: "SingleHeader": { "Name": "haystack" }
         */
        var singleHeader: aws.sdk.kotlin.services.wafv2.model.SingleHeader? = null
        /**
         * Inspect a single query argument. Provide the name of the query argument to inspect, such
         * as UserName or SalesRegion. The name can be up to
         * 30 characters long and isn't case sensitive.
         * This is used only to indicate the web request component for WAF to inspect, in the FieldToMatch specification.
         * Example JSON: "SingleQueryArgument": { "Name": "myArgument" }
         */
        var singleQueryArgument: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument? = null
        /**
         * Inspect the request URI path. This is the part of a web request that identifies a
         * resource, for example, /images/daily-ad.jpg.
         */
        var uriPath: aws.sdk.kotlin.services.wafv2.model.UriPath? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.FieldToMatch) : this() {
            this.allQueryArguments = x.allQueryArguments
            this.body = x.body
            this.jsonBody = x.jsonBody
            this.method = x.method
            this.queryString = x.queryString
            this.singleHeader = x.singleHeader
            this.singleQueryArgument = x.singleQueryArgument
            this.uriPath = x.uriPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.FieldToMatch = FieldToMatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.AllQueryArguments] inside the given [block]
         */
        fun allQueryArguments(block: aws.sdk.kotlin.services.wafv2.model.AllQueryArguments.Builder.() -> kotlin.Unit) {
            this.allQueryArguments = aws.sdk.kotlin.services.wafv2.model.AllQueryArguments.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Body] inside the given [block]
         */
        fun body(block: aws.sdk.kotlin.services.wafv2.model.Body.Builder.() -> kotlin.Unit) {
            this.body = aws.sdk.kotlin.services.wafv2.model.Body.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.JsonBody] inside the given [block]
         */
        fun jsonBody(block: aws.sdk.kotlin.services.wafv2.model.JsonBody.Builder.() -> kotlin.Unit) {
            this.jsonBody = aws.sdk.kotlin.services.wafv2.model.JsonBody.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Method] inside the given [block]
         */
        fun method(block: aws.sdk.kotlin.services.wafv2.model.Method.Builder.() -> kotlin.Unit) {
            this.method = aws.sdk.kotlin.services.wafv2.model.Method.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.QueryString] inside the given [block]
         */
        fun queryString(block: aws.sdk.kotlin.services.wafv2.model.QueryString.Builder.() -> kotlin.Unit) {
            this.queryString = aws.sdk.kotlin.services.wafv2.model.QueryString.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SingleHeader] inside the given [block]
         */
        fun singleHeader(block: aws.sdk.kotlin.services.wafv2.model.SingleHeader.Builder.() -> kotlin.Unit) {
            this.singleHeader = aws.sdk.kotlin.services.wafv2.model.SingleHeader.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument] inside the given [block]
         */
        fun singleQueryArgument(block: aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument.Builder.() -> kotlin.Unit) {
            this.singleQueryArgument = aws.sdk.kotlin.services.wafv2.model.SingleQueryArgument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.UriPath] inside the given [block]
         */
        fun uriPath(block: aws.sdk.kotlin.services.wafv2.model.UriPath.Builder.() -> kotlin.Unit) {
            this.uriPath = aws.sdk.kotlin.services.wafv2.model.UriPath.invoke(block)
        }
    }
}
