// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule group that's defined for an Firewall Manager WAF policy.
 */
class FirewallManagerRuleGroup private constructor(builder: Builder) {
    /**
     * The processing guidance for an Firewall Manager rule. This is like a regular rule Statement, but it can only contain a rule group reference.
     */
    val firewallManagerStatement: aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement? = builder.firewallManagerStatement
    /**
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    val name: kotlin.String? = builder.name
    /**
     * The override action to apply to the rules in a rule group. Used only for rule statements that reference a rule group,
     * like RuleGroupReferenceStatement and ManagedRuleGroupStatement.
     * Set the override action to none to leave the rule actions in effect. Set it to count to only count matches, regardless of the rule action settings.
     * In a Rule, you must specify either this OverrideAction setting or the rule Action setting, but not both:
     * If the rule statement references a rule group, use this override action setting and not the action setting.
     * If the rule statement does not reference a rule group, use the rule action setting and not this rule override action setting.
     */
    val overrideAction: aws.sdk.kotlin.services.wafv2.model.OverrideAction? = builder.overrideAction
    /**
     * If you define more than one rule group in the first or last Firewall Manager rule groups, WAF
     * evaluates each request against the rule groups in order, starting from the lowest priority
     * setting. The priorities don't need to be consecutive, but they must all be
     * different.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.FirewallManagerRuleGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallManagerRuleGroup(")
        append("firewallManagerStatement=$firewallManagerStatement,")
        append("name=$name,")
        append("overrideAction=$overrideAction,")
        append("priority=$priority,")
        append("visibilityConfig=$visibilityConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = firewallManagerStatement?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overrideAction?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FirewallManagerRuleGroup

        if (firewallManagerStatement != other.firewallManagerStatement) return false
        if (name != other.name) return false
        if (overrideAction != other.overrideAction) return false
        if (priority != other.priority) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.FirewallManagerRuleGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The processing guidance for an Firewall Manager rule. This is like a regular rule Statement, but it can only contain a rule group reference.
         */
        var firewallManagerStatement: aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement? = null
        /**
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         */
        var name: kotlin.String? = null
        /**
         * The override action to apply to the rules in a rule group. Used only for rule statements that reference a rule group,
         * like RuleGroupReferenceStatement and ManagedRuleGroupStatement.
         * Set the override action to none to leave the rule actions in effect. Set it to count to only count matches, regardless of the rule action settings.
         * In a Rule, you must specify either this OverrideAction setting or the rule Action setting, but not both:
         * If the rule statement references a rule group, use this override action setting and not the action setting.
         * If the rule statement does not reference a rule group, use the rule action setting and not this rule override action setting.
         */
        var overrideAction: aws.sdk.kotlin.services.wafv2.model.OverrideAction? = null
        /**
         * If you define more than one rule group in the first or last Firewall Manager rule groups, WAF
         * evaluates each request against the rule groups in order, starting from the lowest priority
         * setting. The priorities don't need to be consecutive, but they must all be
         * different.
         */
        var priority: kotlin.Int = 0
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.FirewallManagerRuleGroup) : this() {
            this.firewallManagerStatement = x.firewallManagerStatement
            this.name = x.name
            this.overrideAction = x.overrideAction
            this.priority = x.priority
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.FirewallManagerRuleGroup = FirewallManagerRuleGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement] inside the given [block]
         */
        fun firewallManagerStatement(block: aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement.Builder.() -> kotlin.Unit) {
            this.firewallManagerStatement = aws.sdk.kotlin.services.wafv2.model.FirewallManagerStatement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.OverrideAction] inside the given [block]
         */
        fun overrideAction(block: aws.sdk.kotlin.services.wafv2.model.OverrideAction.Builder.() -> kotlin.Unit) {
            this.overrideAction = aws.sdk.kotlin.services.wafv2.model.OverrideAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }
    }
}
