// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class GetSampledRequestsResponse private constructor(builder: Builder) {
    /**
     * The total number of requests from which GetSampledRequests got a sample of
     * MaxItems requests. If PopulationSize is less than
     * MaxItems, the sample includes every request that your Amazon Web Services resource
     * received during the specified time range.
     */
    val populationSize: kotlin.Long = builder.populationSize
    /**
     * A complex type that contains detailed information about each of the requests in the
     * sample.
     */
    val sampledRequests: List<SampledHttpRequest>? = builder.sampledRequests
    /**
     * Usually, TimeWindow is the time range that you specified in the
     * GetSampledRequests request. However, if your Amazon Web Services resource received more
     * than 5,000 requests during the time range that you specified in the request,
     * GetSampledRequests returns the time range for the first 5,000 requests.
     * Times are in Coordinated Universal Time (UTC) format.
     */
    val timeWindow: aws.sdk.kotlin.services.wafv2.model.TimeWindow? = builder.timeWindow

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSampledRequestsResponse(")
        append("populationSize=$populationSize,")
        append("sampledRequests=$sampledRequests,")
        append("timeWindow=$timeWindow)")
    }

    override fun hashCode(): kotlin.Int {
        var result = populationSize.hashCode()
        result = 31 * result + (sampledRequests?.hashCode() ?: 0)
        result = 31 * result + (timeWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetSampledRequestsResponse

        if (populationSize != other.populationSize) return false
        if (sampledRequests != other.sampledRequests) return false
        if (timeWindow != other.timeWindow) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The total number of requests from which GetSampledRequests got a sample of
         * MaxItems requests. If PopulationSize is less than
         * MaxItems, the sample includes every request that your Amazon Web Services resource
         * received during the specified time range.
         */
        var populationSize: kotlin.Long = 0L
        /**
         * A complex type that contains detailed information about each of the requests in the
         * sample.
         */
        var sampledRequests: List<SampledHttpRequest>? = null
        /**
         * Usually, TimeWindow is the time range that you specified in the
         * GetSampledRequests request. However, if your Amazon Web Services resource received more
         * than 5,000 requests during the time range that you specified in the request,
         * GetSampledRequests returns the time range for the first 5,000 requests.
         * Times are in Coordinated Universal Time (UTC) format.
         */
        var timeWindow: aws.sdk.kotlin.services.wafv2.model.TimeWindow? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse) : this() {
            this.populationSize = x.populationSize
            this.sampledRequests = x.sampledRequests
            this.timeWindow = x.timeWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.GetSampledRequestsResponse = GetSampledRequestsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.TimeWindow] inside the given [block]
         */
        fun timeWindow(block: aws.sdk.kotlin.services.wafv2.model.TimeWindow.Builder.() -> kotlin.Unit) {
            this.timeWindow = aws.sdk.kotlin.services.wafv2.model.TimeWindow.invoke(block)
        }
    }
}
