// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Contains one or more IP addresses or blocks of IP addresses specified in Classless
 * Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges
 * except for /0. For information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
 * Inter-Domain Routing.
 * WAF assigns an ARN to each IPSet that you create. To use an IP set in a
 * rule, you provide the ARN to the Rule statement IPSetReferenceStatement.
 */
class IpSet private constructor(builder: Builder) {
    /**
     * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
     * Examples:
     * To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32.
     * To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
     * 192.0.2.0/24.
     * To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
     * To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
     * For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing.
     */
    val addresses: List<String>? = builder.addresses
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A description of the IP set that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    val id: kotlin.String? = builder.id
    /**
     * The version of the IP addresses, either IPV4 or IPV6.
     */
    val ipAddressVersion: aws.sdk.kotlin.services.wafv2.model.IpAddressVersion? = builder.ipAddressVersion
    /**
     * The name of the IP set. You cannot change the name of an IPSet after you create it.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.IpSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpSet(")
        append("addresses=$addresses,")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("ipAddressVersion=$ipAddressVersion,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addresses?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ipAddressVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IpSet

        if (addresses != other.addresses) return false
        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (ipAddressVersion != other.ipAddressVersion) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.IpSet = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0.
         * Examples:
         * To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32.
         * To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
         * 192.0.2.0/24.
         * To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
         * To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
         * For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing.
         */
        var addresses: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        var arn: kotlin.String? = null
        /**
         * A description of the IP set that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        var id: kotlin.String? = null
        /**
         * The version of the IP addresses, either IPV4 or IPV6.
         */
        var ipAddressVersion: aws.sdk.kotlin.services.wafv2.model.IpAddressVersion? = null
        /**
         * The name of the IP set. You cannot change the name of an IPSet after you create it.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.IpSet) : this() {
            this.addresses = x.addresses
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.ipAddressVersion = x.ipAddressVersion
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.IpSet = IpSet(this)
    }
}
