// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
 * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
 * This configuration is used only for IPSetReferenceStatement. For GeoMatchStatement and RateBasedStatement, use ForwardedIPConfig instead.
 */
class IpSetForwardedIpConfig private constructor(builder: Builder) {
    /**
     * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     * You can specify the following fallback behaviors:
     * MATCH - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
     * NO_MATCH - Treat the web request as not matching the rule statement.
     */
    val fallbackBehavior: aws.sdk.kotlin.services.wafv2.model.FallbackBehavior? = builder.fallbackBehavior
    /**
     * The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to X-Forwarded-For.
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     */
    val headerName: kotlin.String? = builder.headerName
    /**
     * The position in the header to search for the IP address. The header can contain IP
     * addresses of the original client and also of proxies. For example, the header value could
     * be 10.1.1.1, 127.0.0.0, 10.10.10.10 where the first IP address identifies the
     * original client and the rest identify proxies that the request went through.
     * The options for this setting are the following:
     * FIRST - Inspect the first IP address in the list of IP addresses in the
     * header. This is usually the client's original IP.
     * LAST - Inspect the last IP address in the list of IP addresses in the
     * header.
     * ANY - Inspect all IP addresses in the header for a match. If the header
     * contains more than 10 IP addresses, WAF inspects the last 10.
     */
    val position: aws.sdk.kotlin.services.wafv2.model.ForwardedIpPosition? = builder.position

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.IpSetForwardedIpConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpSetForwardedIpConfig(")
        append("fallbackBehavior=$fallbackBehavior,")
        append("headerName=$headerName,")
        append("position=$position)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fallbackBehavior?.hashCode() ?: 0
        result = 31 * result + (headerName?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IpSetForwardedIpConfig

        if (fallbackBehavior != other.fallbackBehavior) return false
        if (headerName != other.headerName) return false
        if (position != other.position) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.IpSetForwardedIpConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         * You can specify the following fallback behaviors:
         * MATCH - Treat the web request as matching the rule statement. WAF applies the rule action to the request.
         * NO_MATCH - Treat the web request as not matching the rule statement.
         */
        var fallbackBehavior: aws.sdk.kotlin.services.wafv2.model.FallbackBehavior? = null
        /**
         * The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to X-Forwarded-For.
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         */
        var headerName: kotlin.String? = null
        /**
         * The position in the header to search for the IP address. The header can contain IP
         * addresses of the original client and also of proxies. For example, the header value could
         * be 10.1.1.1, 127.0.0.0, 10.10.10.10 where the first IP address identifies the
         * original client and the rest identify proxies that the request went through.
         * The options for this setting are the following:
         * FIRST - Inspect the first IP address in the list of IP addresses in the
         * header. This is usually the client's original IP.
         * LAST - Inspect the last IP address in the list of IP addresses in the
         * header.
         * ANY - Inspect all IP addresses in the header for a match. If the header
         * contains more than 10 IP addresses, WAF inspects the last 10.
         */
        var position: aws.sdk.kotlin.services.wafv2.model.ForwardedIpPosition? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.IpSetForwardedIpConfig) : this() {
            this.fallbackBehavior = x.fallbackBehavior
            this.headerName = x.headerName
            this.position = x.position
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.IpSetForwardedIpConfig = IpSetForwardedIpConfig(this)
    }
}
