// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Defines an association between Amazon Kinesis Data Firehose destinations and a web ACL
 * resource, for logging from WAF. As part of the association, you can specify parts of
 * the standard logging fields to keep out of the logs and you can specify filters so that you
 * log only a subset of the logging records.
 */
class LoggingConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Kinesis Data Firehose Amazon Resource Name (ARNs) that you want to associate
     * with the web ACL.
     */
    val logDestinationConfigs: List<String>? = builder.logDestinationConfigs
    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped.
     * You can filter on the rule action and on the web request labels that were applied by
     * matching rules during web ACL evaluation.
     */
    val loggingFilter: aws.sdk.kotlin.services.wafv2.model.LoggingFilter? = builder.loggingFilter
    /**
     * Indicates whether the logging configuration was created by Firewall Manager, as part of an
     * WAF policy configuration. If true, only Firewall Manager can modify or delete the
     * configuration.
     */
    val managedByFirewallManager: kotlin.Boolean = builder.managedByFirewallManager
    /**
     * The parts of the request that you want to keep out of the logs. For
     * example, if you redact the SingleHeader field, the HEADER field in the firehose will be xxx.
     * You can specify only the following fields for redaction: UriPath, QueryString, SingleHeader, Method, and JsonBody.
     */
    val redactedFields: List<FieldToMatch>? = builder.redactedFields
    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with
     * LogDestinationConfigs.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfiguration(")
        append("logDestinationConfigs=$logDestinationConfigs,")
        append("loggingFilter=$loggingFilter,")
        append("managedByFirewallManager=$managedByFirewallManager,")
        append("redactedFields=$redactedFields,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = logDestinationConfigs?.hashCode() ?: 0
        result = 31 * result + (loggingFilter?.hashCode() ?: 0)
        result = 31 * result + (managedByFirewallManager.hashCode())
        result = 31 * result + (redactedFields?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LoggingConfiguration

        if (logDestinationConfigs != other.logDestinationConfigs) return false
        if (loggingFilter != other.loggingFilter) return false
        if (managedByFirewallManager != other.managedByFirewallManager) return false
        if (redactedFields != other.redactedFields) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Kinesis Data Firehose Amazon Resource Name (ARNs) that you want to associate
         * with the web ACL.
         */
        var logDestinationConfigs: List<String>? = null
        /**
         * Filtering that specifies which web requests are kept in the logs and which are dropped.
         * You can filter on the rule action and on the web request labels that were applied by
         * matching rules during web ACL evaluation.
         */
        var loggingFilter: aws.sdk.kotlin.services.wafv2.model.LoggingFilter? = null
        /**
         * Indicates whether the logging configuration was created by Firewall Manager, as part of an
         * WAF policy configuration. If true, only Firewall Manager can modify or delete the
         * configuration.
         */
        var managedByFirewallManager: kotlin.Boolean = false
        /**
         * The parts of the request that you want to keep out of the logs. For
         * example, if you redact the SingleHeader field, the HEADER field in the firehose will be xxx.
         * You can specify only the following fields for redaction: UriPath, QueryString, SingleHeader, Method, and JsonBody.
         */
        var redactedFields: List<FieldToMatch>? = null
        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with
         * LogDestinationConfigs.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration) : this() {
            this.logDestinationConfigs = x.logDestinationConfigs
            this.loggingFilter = x.loggingFilter
            this.managedByFirewallManager = x.managedByFirewallManager
            this.redactedFields = x.redactedFields
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.LoggingConfiguration = LoggingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.LoggingFilter] inside the given [block]
         */
        fun loggingFilter(block: aws.sdk.kotlin.services.wafv2.model.LoggingFilter.Builder.() -> kotlin.Unit) {
            this.loggingFilter = aws.sdk.kotlin.services.wafv2.model.LoggingFilter.invoke(block)
        }
    }
}
