// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * High-level information about a managed rule group, returned by ListAvailableManagedRuleGroups. This provides information like the name and vendor name, that you provide when you add a ManagedRuleGroupStatement to a web ACL. Managed rule groups include Amazon Web Services Managed Rules rule groups, which are free of charge to WAF customers, and Amazon Web Services Marketplace managed rule groups, which you can subscribe to through Amazon Web Services Marketplace.
 */
class ManagedRuleGroupSummary private constructor(builder: Builder) {
    /**
     * The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon Web Services Marketplace seller who manages it.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    val name: kotlin.String? = builder.name
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
     */
    val vendorName: kotlin.String? = builder.vendorName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedRuleGroupSummary(")
        append("description=$description,")
        append("name=$name,")
        append("vendorName=$vendorName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ManagedRuleGroupSummary

        if (description != other.description) return false
        if (name != other.name) return false
        if (vendorName != other.vendorName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the managed rule group, provided by Amazon Web Services Managed Rules or the Amazon Web Services Marketplace seller who manages it.
         */
        var description: kotlin.String? = null
        /**
         * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
         */
        var name: kotlin.String? = null
        /**
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
         */
        var vendorName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupSummary) : this() {
            this.description = x.description
            this.name = x.name
            this.vendorName = x.vendorName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ManagedRuleGroupSummary = ManagedRuleGroupSummary(this)
    }
}
