// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class PutManagedRuleSetVersionsRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the managed rule set. The ID is returned in the responses to commands like list. You provide it to operations like get and update.
     */
    val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation.
     */
    val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
     * This name is assigned to the corresponding managed rule group, which your customers can access and use.
     */
    val name: kotlin.String? = builder.name
    /**
     * The version of the named managed rule group that you'd like your customers to choose,
     * from among your version offerings.
     */
    val recommendedVersion: kotlin.String? = builder.recommendedVersion
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.
     * API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * The versions of the named managed rule group that you want to offer to your customers.
     */
    val versionsToPublish: Map<String, VersionToPublish>? = builder.versionsToPublish

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.PutManagedRuleSetVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutManagedRuleSetVersionsRequest(")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name,")
        append("recommendedVersion=$recommendedVersion,")
        append("scope=$scope,")
        append("versionsToPublish=$versionsToPublish)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recommendedVersion?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (versionsToPublish?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutManagedRuleSetVersionsRequest

        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false
        if (recommendedVersion != other.recommendedVersion) return false
        if (scope != other.scope) return false
        if (versionsToPublish != other.versionsToPublish) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.PutManagedRuleSetVersionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the managed rule set. The ID is returned in the responses to commands like list. You provide it to operations like get and update.
         */
        var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation.
         */
        var lockToken: kotlin.String? = null
        /**
         * The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.
         * This name is assigned to the corresponding managed rule group, which your customers can access and use.
         */
        var name: kotlin.String? = null
        /**
         * The version of the named managed rule group that you'd like your customers to choose,
         * from among your version offerings.
         */
        var recommendedVersion: kotlin.String? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT --region=us-east-1.
         * API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * The versions of the named managed rule group that you want to offer to your customers.
         */
        var versionsToPublish: Map<String, VersionToPublish>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.PutManagedRuleSetVersionsRequest) : this() {
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
            this.recommendedVersion = x.recommendedVersion
            this.scope = x.scope
            this.versionsToPublish = x.versionsToPublish
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.PutManagedRuleSetVersionsRequest = PutManagedRuleSetVersionsRequest(this)
    }
}
