// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class PutPermissionPolicyRequest private constructor(builder: Builder) {
    /**
     * The policy to attach to the specified rule group.
     * The policy specifications must conform to the following:
     * The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.
     * The policy must include specifications for Effect, Action, and Principal.
     * Effect must specify Allow.
     * Action must specify wafv2:CreateWebACL, wafv2:UpdateWebACL, and wafv2:PutFirewallManagerRuleGroups. WAF rejects any extra actions or wildcard actions in the policy.
     * The policy must not include a Resource parameter.
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies.
     */
    val policy: kotlin.String? = builder.policy
    /**
     * The Amazon Resource Name (ARN) of the RuleGroup to which you want to
     * attach the policy.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.PutPermissionPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPermissionPolicyRequest(")
        append("policy=$policy,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = policy?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutPermissionPolicyRequest

        if (policy != other.policy) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.PutPermissionPolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The policy to attach to the specified rule group.
         * The policy specifications must conform to the following:
         * The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.
         * The policy must include specifications for Effect, Action, and Principal.
         * Effect must specify Allow.
         * Action must specify wafv2:CreateWebACL, wafv2:UpdateWebACL, and wafv2:PutFirewallManagerRuleGroups. WAF rejects any extra actions or wildcard actions in the policy.
         * The policy must not include a Resource parameter.
         * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies.
         */
        var policy: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the RuleGroup to which you want to
         * attach the policy.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.PutPermissionPolicyRequest) : this() {
            this.policy = x.policy
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.PutPermissionPolicyRequest = PutPermissionPolicyRequest(this)
    }
}
