// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
 * WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by WAF. If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by WAF.
 * When the rule action triggers, WAF blocks additional requests from the IP address until the request rate falls below the limit.
 * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
 * An IP match statement with an IP set that specified the address 192.0.2.44.
 * A string match statement that searches in the User-Agent header for the string BadBot.
 * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet both of the conditions in the statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet both conditions are not counted towards the rate limit and are not affected by this rule.
 * You cannot nest a RateBasedStatement inside another statement, for example inside a NotStatement or OrStatement. You can define a RateBasedStatement inside a web ACL and inside a rule group.
 */
class RateBasedStatement private constructor(builder: Builder) {
    /**
     * Setting that indicates how to aggregate the request counts. The options are the
     * following:
     * IP - Aggregate the request counts on the IP address from the web request
     * origin.
     * FORWARDED_IP - Aggregate the request counts on the first IP address in an
     * HTTP header. If you use this, configure the ForwardedIPConfig, to
     * specify the header to use.
     */
    val aggregateKeyType: aws.sdk.kotlin.services.wafv2.model.RateBasedStatementAggregateKeyType? = builder.aggregateKeyType
    /**
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
     * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
     * This is required if AggregateKeyType is set to
     * FORWARDED_IP.
     */
    val forwardedIpConfig: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig? = builder.forwardedIpConfig
    /**
     * The limit on requests per 5-minute period for a single originating IP address. If the
     * statement includes a ScopeDownStatement, this limit is applied only to the
     * requests that match the statement.
     */
    val limit: kotlin.Long = builder.limit
    /**
     * An optional nested statement that narrows the scope of the web requests that are
     * evaluated by the rate-based statement. Requests are only tracked by the rate-based
     * statement if they match the scope-down statement. You can use any nestable Statement in the scope-down statement, and you can nest statements at any
     * level, the same as you can for a rule statement.
     */
    val scopeDownStatement: aws.sdk.kotlin.services.wafv2.model.Statement? = builder.scopeDownStatement

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RateBasedStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RateBasedStatement(")
        append("aggregateKeyType=$aggregateKeyType,")
        append("forwardedIpConfig=$forwardedIpConfig,")
        append("limit=$limit,")
        append("scopeDownStatement=$scopeDownStatement)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregateKeyType?.hashCode() ?: 0
        result = 31 * result + (forwardedIpConfig?.hashCode() ?: 0)
        result = 31 * result + (limit.hashCode())
        result = 31 * result + (scopeDownStatement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RateBasedStatement

        if (aggregateKeyType != other.aggregateKeyType) return false
        if (forwardedIpConfig != other.forwardedIpConfig) return false
        if (limit != other.limit) return false
        if (scopeDownStatement != other.scopeDownStatement) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RateBasedStatement = Builder(this).apply(block).build()

    class Builder {
        /**
         * Setting that indicates how to aggregate the request counts. The options are the
         * following:
         * IP - Aggregate the request counts on the IP address from the web request
         * origin.
         * FORWARDED_IP - Aggregate the request counts on the first IP address in an
         * HTTP header. If you use this, configure the ForwardedIPConfig, to
         * specify the header to use.
         */
        var aggregateKeyType: aws.sdk.kotlin.services.wafv2.model.RateBasedStatementAggregateKeyType? = null
        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * If the specified header isn't present in the request, WAF doesn't apply the rule to the web request at all.
         * This is required if AggregateKeyType is set to
         * FORWARDED_IP.
         */
        var forwardedIpConfig: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig? = null
        /**
         * The limit on requests per 5-minute period for a single originating IP address. If the
         * statement includes a ScopeDownStatement, this limit is applied only to the
         * requests that match the statement.
         */
        var limit: kotlin.Long = 0L
        /**
         * An optional nested statement that narrows the scope of the web requests that are
         * evaluated by the rate-based statement. Requests are only tracked by the rate-based
         * statement if they match the scope-down statement. You can use any nestable Statement in the scope-down statement, and you can nest statements at any
         * level, the same as you can for a rule statement.
         */
        var scopeDownStatement: aws.sdk.kotlin.services.wafv2.model.Statement? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RateBasedStatement) : this() {
            this.aggregateKeyType = x.aggregateKeyType
            this.forwardedIpConfig = x.forwardedIpConfig
            this.limit = x.limit
            this.scopeDownStatement = x.scopeDownStatement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RateBasedStatement = RateBasedStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig] inside the given [block]
         */
        fun forwardedIpConfig(block: aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig.Builder.() -> kotlin.Unit) {
            this.forwardedIpConfig = aws.sdk.kotlin.services.wafv2.model.ForwardedIpConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.Statement] inside the given [block]
         */
        fun scopeDownStatement(block: aws.sdk.kotlin.services.wafv2.model.Statement.Builder.() -> kotlin.Unit) {
            this.scopeDownStatement = aws.sdk.kotlin.services.wafv2.model.Statement.invoke(block)
        }
    }
}
