// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * High-level information about a RegexPatternSet, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a RegexPatternSet, and the ARN, that you provide to the RegexPatternSetReferenceStatement to use the pattern set in a Rule.
 */
class RegexPatternSetSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the entity.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A description of the set that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    val id: kotlin.String? = builder.id
    /**
     * A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation.
     */
    val lockToken: kotlin.String? = builder.lockToken
    /**
     * The name of the data type instance. You cannot change the name after you create the instance.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.RegexPatternSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexPatternSetSummary(")
        append("arn=$arn,")
        append("description=$description,")
        append("id=$id,")
        append("lockToken=$lockToken,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lockToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RegexPatternSetSummary

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lockToken != other.lockToken) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.RegexPatternSetSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the entity.
         */
        var arn: kotlin.String? = null
        /**
         * A description of the set that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        var id: kotlin.String? = null
        /**
         * A token used for optimistic locking. WAF returns a token to your get and list requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like update and delete. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a WAFOptimisticLockException. If this happens, perform another get, and use the new token returned by that operation.
         */
        var lockToken: kotlin.String? = null
        /**
         * The name of the data type instance. You cannot change the name after you create the instance.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.RegexPatternSetSummary) : this() {
            this.arn = x.arn
            this.description = x.description
            this.id = x.id
            this.lockToken = x.lockToken
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.RegexPatternSetSummary = RegexPatternSetSummary(this)
    }
}
